<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Event/Event.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:44df1cb5691958b88be856f793adabca)
 */

/**
 * Database access object for the Event entity.
 */
class CRM_Event_DAO_Event extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_event';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = TRUE;

  /**
   * Event
   *
   * @var int unsigned
   */
  public $id;

  /**
   * Event Title (e.g. Fall Fundraiser Dinner)
   *
   * @var string
   */
  public $title;

  /**
   * Brief summary of event. Text and html allowed. Displayed on Event Registration form and can be used on other CMS pages which need an event summary.
   *
   * @var text
   */
  public $summary;

  /**
   * Full description of event. Text and html allowed. Displayed on built-in Event Information screens.
   *
   * @var text
   */
  public $description;

  /**
   * Event Type ID.Implicit FK to civicrm_option_value where option_group = event_type.
   *
   * @var int unsigned
   */
  public $event_type_id;

  /**
   * Should we expose the participant list? Implicit FK to civicrm_option_value where option_group = participant_listing.
   *
   * @var int unsigned
   */
  public $participant_listing_id;

  /**
   * Public events will be included in the iCal feeds. Access to private event information may be limited using ACLs.
   *
   * @var boolean
   */
  public $is_public;

  /**
   * Date and time that event starts.
   *
   * @var datetime
   */
  public $start_date;

  /**
   * Date and time that event ends. May be NULL if no defined end date/time
   *
   * @var datetime
   */
  public $end_date;

  /**
   * If true, include registration link on Event Info page.
   *
   * @var boolean
   */
  public $is_online_registration;

  /**
   * Text for link to Event Registration form which is displayed on Event Information screen when is_online_registration is true.
   *
   * @var string
   */
  public $registration_link_text;

  /**
   * Date and time that online registration starts.
   *
   * @var datetime
   */
  public $registration_start_date;

  /**
   * Date and time that online registration ends.
   *
   * @var datetime
   */
  public $registration_end_date;

  /**
   * Maximum number of registered participants to allow. After max is reached, a custom Event Full message is displayed. If NULL, allow unlimited number of participants.
   *
   * @var int unsigned
   */
  public $max_participants;

  /**
   * Message to display on Event Information page and INSTEAD OF Event Registration form if maximum participants are signed up. Can include email address/info about getting on a waiting list, etc. Text and html allowed.
   *
   * @var text
   */
  public $event_full_text;

  /**
   * If true, one or more fee amounts must be set and a Payment Processor must be configured for Online Event Registration.
   *
   * @var boolean
   */
  public $is_monetary;

  /**
   * Financial type assigned to paid event registrations for this event. Required if is_monetary is true.
   *
   * @var int unsigned
   */
  public $financial_type_id;

  /**
   * Payment Processors configured for this Event (if is_monetary is true)
   *
   * @var string
   */
  public $payment_processor;

  /**
   * Include a map block on the Event Information page when geocode info is available and a mapping provider has been specified?
   *
   * @var boolean
   */
  public $is_map;

  /**
   * Is this Event enabled or disabled/cancelled?
   *
   * @var boolean
   */
  public $is_active;

  /**
   * @var string
   */
  public $fee_label;

  /**
   * If true, show event location.
   *
   * @var boolean
   */
  public $is_show_location;

  /**
   * FK to Location Block ID
   *
   * @var int unsigned
   */
  public $loc_block_id;

  /**
   * Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.
   *
   * @var int unsigned
   */
  public $default_role_id;

  /**
   * Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.
   *
   * @var text
   */
  public $intro_text;

  /**
   * Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.
   *
   * @var text
   */
  public $footer_text;

  /**
   * Title for Confirmation page.
   *
   * @var string
   */
  public $confirm_title;

  /**
   * Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.
   *
   * @var text
   */
  public $confirm_text;

  /**
   * Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.
   *
   * @var text
   */
  public $confirm_footer_text;

  /**
   * If true, confirmation is automatically emailed to contact on successful registration.
   *
   * @var boolean
   */
  public $is_email_confirm;

  /**
   * text to include above standard event info on confirmation email. emails are text-only, so do not allow html for now
   *
   * @var text
   */
  public $confirm_email_text;

  /**
   * FROM email name used for confirmation emails.
   *
   * @var string
   */
  public $confirm_from_name;

  /**
   * FROM email address used for confirmation emails.
   *
   * @var string
   */
  public $confirm_from_email;

  /**
   * comma-separated list of email addresses to cc each time a confirmation is sent
   *
   * @var string
   */
  public $cc_confirm;

  /**
   * comma-separated list of email addresses to bcc each time a confirmation is sent
   *
   * @var string
   */
  public $bcc_confirm;

  /**
   * FK to civicrm_option_value.
   *
   * @var int unsigned
   */
  public $default_fee_id;

  /**
   * FK to civicrm_option_value.
   *
   * @var int unsigned
   */
  public $default_discount_fee_id;

  /**
   * Title for ThankYou page.
   *
   * @var string
   */
  public $thankyou_title;

  /**
   * ThankYou Text.
   *
   * @var text
   */
  public $thankyou_text;

  /**
   * Footer message.
   *
   * @var text
   */
  public $thankyou_footer_text;

  /**
   * if true - allows the user to send payment directly to the org later
   *
   * @var boolean
   */
  public $is_pay_later;

  /**
   * The text displayed to the user in the main form
   *
   * @var text
   */
  public $pay_later_text;

  /**
   * The receipt sent to the user instead of the normal receipt text
   *
   * @var text
   */
  public $pay_later_receipt;

  /**
   * is partial payment enabled for this event
   *
   * @var boolean
   */
  public $is_partial_payment;

  /**
   * Initial amount label for partial payment
   *
   * @var string
   */
  public $initial_amount_label;

  /**
   * Initial amount help text for partial payment
   *
   * @var text
   */
  public $initial_amount_help_text;

  /**
   * Minimum initial amount for partial payment
   *
   * @var float
   */
  public $min_initial_amount;

  /**
   * if true - allows the user to register multiple participants for event
   *
   * @var boolean
   */
  public $is_multiple_registrations;

  /**
   * Maximum number of additional participants that can be registered on a single booking
   *
   * @var int unsigned
   */
  public $max_additional_participants;

  /**
   * if true - allows the user to register multiple registrations from same email address.
   *
   * @var boolean
   */
  public $allow_same_participant_emails;

  /**
   * Whether the event has waitlist support.
   *
   * @var boolean
   */
  public $has_waitlist;

  /**
   * Whether participants require approval before they can finish registering.
   *
   * @var boolean
   */
  public $requires_approval;

  /**
   * Expire pending but unconfirmed registrations after this many hours.
   *
   * @var int unsigned
   */
  public $expiration_time;

  /**
   * Allow self service cancellation or transfer for event?
   *
   * @var boolean
   */
  public $allow_selfcancelxfer;

  /**
   * Number of hours prior to event start date to allow self-service cancellation or transfer.
   *
   * @var int unsigned
   */
  public $selfcancelxfer_time;

  /**
   * Text to display when the event is full, but participants can signup for a waitlist.
   *
   * @var text
   */
  public $waitlist_text;

  /**
   * Text to display when the approval is required to complete registration for an event.
   *
   * @var text
   */
  public $approval_req_text;

  /**
   * whether the event has template
   *
   * @var boolean
   */
  public $is_template;

  /**
   * Event Template Title
   *
   * @var string
   */
  public $template_title;

  /**
   * FK to civicrm_contact, who created this event
   *
   * @var int unsigned
   */
  public $created_id;

  /**
   * Date and time that event was created.
   *
   * @var datetime
   */
  public $created_date;

  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;

  /**
   * The campaign for which this event has been created.
   *
   * @var int unsigned
   */
  public $campaign_id;

  /**
   * Can people share the event through social media?
   *
   * @var boolean
   */
  public $is_share;

  /**
   * If false, the event booking confirmation screen gets skipped
   *
   * @var boolean
   */
  public $is_confirm_enabled;

  /**
   * Implicit FK to civicrm_event: parent event
   *
   * @var int unsigned
   */
  public $parent_event_id;

  /**
   * Subevent slot label. Implicit FK to civicrm_option_value where option_group = conference_slot.
   *
   * @var int unsigned
   */
  public $slot_label_id;

  /**
   * Rule to use when matching registrations for this event
   *
   * @var int unsigned
   */
  public $dedupe_rule_group_id;

  /**
   * if true than billing block is required this event
   *
   * @var boolean
   */
  public $is_billing_required;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_event';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'loc_block_id', 'civicrm_loc_block', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'created_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'campaign_id', 'civicrm_campaign', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'dedupe_rule_group_id', 'civicrm_dedupe_rule_group', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Event ID'),
          'description' => ts('Event'),
          'required' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
        ],
        'event_title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Title'),
          'description' => ts('Event Title (e.g. Fall Fundraiser Dinner)'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_event.title',
          'headerPattern' => '/(event.)?title$/i',
          'dataPattern' => '',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'summary' => [
          'name' => 'summary',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Summary'),
          'description' => ts('Brief summary of event. Text and html allowed. Displayed on Event Registration form and can be used on other CMS pages which need an event summary.'),
          'rows' => 4,
          'cols' => 60,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'event_description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Description'),
          'description' => ts('Full description of event. Text and html allowed. Displayed on built-in Event Information screens.'),
          'rows' => 8,
          'cols' => 60,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'event_type_id' => [
          'name' => 'event_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Event Type'),
          'description' => ts('Event Type ID.Implicit FK to civicrm_option_value where option_group = event_type.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'event_type',
            'optionEditPath' => 'civicrm/admin/options/event_type',
          ]
        ],
        'participant_listing_id' => [
          'name' => 'participant_listing_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Participant Listing'),
          'description' => ts('Should we expose the participant list? Implicit FK to civicrm_option_value where option_group = participant_listing.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'participant_listing',
            'optionEditPath' => 'civicrm/admin/options/participant_listing',
          ]
        ],
        'is_public' => [
          'name' => 'is_public',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Event Public'),
          'description' => ts('Public events will be included in the iCal feeds. Access to private event information may be limited using ACLs.'),
          'default' => '1',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'event_start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event Start Date'),
          'description' => ts('Date and time that event starts.'),
          'import' => TRUE,
          'where' => 'civicrm_event.start_date',
          'headerPattern' => '/^start|(s(tart\s)?date)$/i',
          'dataPattern' => '',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
        ],
        'event_end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event End Date'),
          'description' => ts('Date and time that event ends. May be NULL if no defined end date/time'),
          'import' => TRUE,
          'where' => 'civicrm_event.end_date',
          'headerPattern' => '/^end|(e(nd\s)?date)$/i',
          'dataPattern' => '',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
        ],
        'is_online_registration' => [
          'name' => 'is_online_registration',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Online Registration'),
          'description' => ts('If true, include registration link on Event Info page.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'registration_link_text' => [
          'name' => 'registration_link_text',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Registration Link Text'),
          'description' => ts('Text for link to Event Registration form which is displayed on Event Information screen when is_online_registration is true.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'registration_start_date' => [
          'name' => 'registration_start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Registration Start Date'),
          'description' => ts('Date and time that online registration starts.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
        ],
        'registration_end_date' => [
          'name' => 'registration_end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Registration End Date'),
          'description' => ts('Date and time that online registration ends.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
        ],
        'max_participants' => [
          'name' => 'max_participants',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Max Participants'),
          'description' => ts('Maximum number of registered participants to allow. After max is reached, a custom Event Full message is displayed. If NULL, allow unlimited number of participants.'),
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'event_full_text' => [
          'name' => 'event_full_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Event Information'),
          'description' => ts('Message to display on Event Information page and INSTEAD OF Event Registration form if maximum participants are signed up. Can include email address/info about getting on a waiting list, etc. Text and html allowed.'),
          'rows' => 4,
          'cols' => 60,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'is_monetary' => [
          'name' => 'is_monetary',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is this a PAID event?'),
          'description' => ts('If true, one or more fee amounts must be set and a Payment Processor must be configured for Online Event Registration.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'financial_type_id' => [
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type'),
          'description' => ts('Financial type assigned to paid event registrations for this event. Required if is_monetary is true.'),
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ]
        ],
        'payment_processor' => [
          'name' => 'payment_processor',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Payment Processor'),
          'description' => ts('Payment Processors configured for this Event (if is_monetary is true)'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_payment_processor',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ]
        ],
        'is_map' => [
          'name' => 'is_map',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Map Enabled'),
          'description' => ts('Include a map block on the Event Information page when geocode info is available and a mapping provider has been specified?'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Active'),
          'description' => ts('Is this Event enabled or disabled/cancelled?'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'fee_label' => [
          'name' => 'fee_label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Fee Label'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_event.fee_label',
          'headerPattern' => '/^fee|(f(ee\s)?label)$/i',
          'dataPattern' => '',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'is_show_location' => [
          'name' => 'is_show_location',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('show location'),
          'description' => ts('If true, show event location.'),
          'default' => '1',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'loc_block_id' => [
          'name' => 'loc_block_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location Block ID'),
          'description' => ts('FK to Location Block ID'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_LocBlock',
        ],
        'default_role_id' => [
          'name' => 'default_role_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Role'),
          'description' => ts('Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.'),
          'import' => TRUE,
          'where' => 'civicrm_event.default_role_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => TRUE,
          'default' => '1',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'participant_role',
            'optionEditPath' => 'civicrm/admin/options/participant_role',
          ]
        ],
        'intro_text' => [
          'name' => 'intro_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Introductory Message'),
          'description' => ts('Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'footer_text' => [
          'name' => 'footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Message'),
          'description' => ts('Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'confirm_title' => [
          'name' => 'confirm_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirmation Title'),
          'description' => ts('Title for Confirmation page.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'confirm_text' => [
          'name' => 'confirm_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Confirm Text'),
          'description' => ts('Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'confirm_footer_text' => [
          'name' => 'confirm_footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Text'),
          'description' => ts('Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'is_email_confirm' => [
          'name' => 'is_email_confirm',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is confirm email'),
          'description' => ts('If true, confirmation is automatically emailed to contact on successful registration.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'confirm_email_text' => [
          'name' => 'confirm_email_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Confirmation Email Text'),
          'description' => ts('text to include above standard event info on confirmation email. emails are text-only, so do not allow html for now'),
          'rows' => 4,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'confirm_from_name' => [
          'name' => 'confirm_from_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirm From Name'),
          'description' => ts('FROM email name used for confirmation emails.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'confirm_from_email' => [
          'name' => 'confirm_from_email',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Confirm From Email'),
          'description' => ts('FROM email address used for confirmation emails.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'cc_confirm' => [
          'name' => 'cc_confirm',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Cc Confirm'),
          'description' => ts('comma-separated list of email addresses to cc each time a confirmation is sent'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'bcc_confirm' => [
          'name' => 'bcc_confirm',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Bcc Confirm'),
          'description' => ts('comma-separated list of email addresses to bcc each time a confirmation is sent'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'default_fee_id' => [
          'name' => 'default_fee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Fee ID'),
          'description' => ts('FK to civicrm_option_value.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
        ],
        'default_discount_fee_id' => [
          'name' => 'default_discount_fee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default Discount Fee ID'),
          'description' => ts('FK to civicrm_option_value.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
        ],
        'thankyou_title' => [
          'name' => 'thankyou_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('ThankYou Title'),
          'description' => ts('Title for ThankYou page.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'thankyou_text' => [
          'name' => 'thankyou_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('ThankYou Text'),
          'description' => ts('ThankYou Text.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'thankyou_footer_text' => [
          'name' => 'thankyou_footer_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Footer Text'),
          'description' => ts('Footer message.'),
          'rows' => 6,
          'cols' => 50,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'is_pay_later' => [
          'name' => 'is_pay_later',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Pay Later Allowed'),
          'description' => ts('if true - allows the user to send payment directly to the org later'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'pay_later_text' => [
          'name' => 'pay_later_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Pay Later Text'),
          'description' => ts('The text displayed to the user in the main form'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'pay_later_receipt' => [
          'name' => 'pay_later_receipt',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Pay Later Receipt Text'),
          'description' => ts('The receipt sent to the user instead of the normal receipt text'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'is_partial_payment' => [
          'name' => 'is_partial_payment',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Partial Payments Enabled'),
          'description' => ts('is partial payment enabled for this event'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'initial_amount_label' => [
          'name' => 'initial_amount_label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Initial Amount Label'),
          'description' => ts('Initial amount label for partial payment'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'initial_amount_help_text' => [
          'name' => 'initial_amount_help_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Initial Amount Help Text'),
          'description' => ts('Initial amount help text for partial payment'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'min_initial_amount' => [
          'name' => 'min_initial_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Minimum Initial Amount'),
          'description' => ts('Minimum initial amount for partial payment'),
          'precision' => [
            20,
            2
          ],
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'is_multiple_registrations' => [
          'name' => 'is_multiple_registrations',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Allow Multiple Registrations'),
          'description' => ts('if true - allows the user to register multiple participants for event'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'max_additional_participants' => [
          'name' => 'max_additional_participants',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum number of additional participants per registration'),
          'description' => ts('Maximum number of additional participants that can be registered on a single booking'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
        ],
        'allow_same_participant_emails' => [
          'name' => 'allow_same_participant_emails',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Does Event allow multiple registrations from same email address?'),
          'description' => ts('if true - allows the user to register multiple registrations from same email address.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'has_waitlist' => [
          'name' => 'has_waitlist',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Waitlist Enabled'),
          'description' => ts('Whether the event has waitlist support.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'requires_approval' => [
          'name' => 'requires_approval',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Requires Approval'),
          'description' => ts('Whether participants require approval before they can finish registering.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'expiration_time' => [
          'name' => 'expiration_time',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Expiration Time'),
          'description' => ts('Expire pending but unconfirmed registrations after this many hours.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'allow_selfcancelxfer' => [
          'name' => 'allow_selfcancelxfer',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Allow Self-service Cancellation or Transfer'),
          'description' => ts('Allow self service cancellation or transfer for event?'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'selfcancelxfer_time' => [
          'name' => 'selfcancelxfer_time',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Self-service Cancellation or Transfer Time'),
          'description' => ts('Number of hours prior to event start date to allow self-service cancellation or transfer.'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'waitlist_text' => [
          'name' => 'waitlist_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Waitlist Text'),
          'description' => ts('Text to display when the event is full, but participants can signup for a waitlist.'),
          'rows' => 4,
          'cols' => 60,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'approval_req_text' => [
          'name' => 'approval_req_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Approval Req Text'),
          'description' => ts('Text to display when the approval is required to complete registration for an event.'),
          'rows' => 4,
          'cols' => 60,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
        ],
        'is_template' => [
          'name' => 'is_template',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is an Event Template'),
          'description' => ts('whether the event has template'),
          'required' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'template_title' => [
          'name' => 'template_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Event Template Title'),
          'description' => ts('Event Template Title'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_event.template_title',
          'headerPattern' => '/(template.)?title$/i',
          'dataPattern' => '',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to civicrm_contact, who created this event'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Event Created Date'),
          'description' => ts('Date and time that event was created.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
        ],
        'currency' => [
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency'),
          'description' => ts('3 character string, value from config setting or input via user.'),
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'import' => TRUE,
          'where' => 'civicrm_event.currency',
          'headerPattern' => '/cur(rency)?/i',
          'dataPattern' => '/^[A-Z]{3}$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'name',
          ]
        ],
        'campaign_id' => [
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign'),
          'description' => ts('The campaign for which this event has been created.'),
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'html' => [
            'type' => 'EntityRef',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_campaign',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          ]
        ],
        'is_share' => [
          'name' => 'is_share',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is shared through social media'),
          'description' => ts('Can people share the event through social media?'),
          'default' => '1',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'is_confirm_enabled' => [
          'name' => 'is_confirm_enabled',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is the booking confirmation screen enabled?'),
          'description' => ts('If false, the event booking confirmation screen gets skipped'),
          'default' => '1',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'parent_event_id' => [
          'name' => 'parent_event_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Parent Event ID'),
          'description' => ts('Implicit FK to civicrm_event: parent event'),
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'EntityRef',
          ],
        ],
        'slot_label_id' => [
          'name' => 'slot_label_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Subevent Slot Label ID'),
          'description' => ts('Subevent slot label. Implicit FK to civicrm_option_value where option_group = conference_slot.'),
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
        ],
        'dedupe_rule_group_id' => [
          'name' => 'dedupe_rule_group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Dedupe Rule'),
          'description' => ts('Rule to use when matching registrations for this event'),
          'default' => 'NULL',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'FKClassName' => 'CRM_Dedupe_DAO_RuleGroup',
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_dedupe_rule_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
          ]
        ],
        'is_billing_required' => [
          'name' => 'is_billing_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is billing block required'),
          'description' => ts('if true than billing block is required this event'),
          'default' => '0',
          'table_name' => 'civicrm_event',
          'entity' => 'Event',
          'bao' => 'CRM_Event_BAO_Event',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'event', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'event', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_event_type_id' => [
        'name' => 'index_event_type_id',
        'field' => [
          0 => 'event_type_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_event::0::event_type_id',
      ],
      'index_participant_listing_id' => [
        'name' => 'index_participant_listing_id',
        'field' => [
          0 => 'participant_listing_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_event::0::participant_listing_id',
      ],
      'index_parent_event_id' => [
        'name' => 'index_parent_event_id',
        'field' => [
          0 => 'parent_event_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_event::0::parent_event_id',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
