<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Core/Job.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Core_DAO_Job extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_job';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Job Id
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Which Domain is this scheduled job for
   *
   * @var int unsigned
   */
  public $domain_id;
  /**
   * Scheduled job run frequency.
   *
   * @var string
   */
  public $run_frequency;
  /**
   * When was this cron entry last run
   *
   * @var datetime
   */
  public $last_run;
  /**
   * When is this cron entry scheduled to run
   *
   * @var timestamp
   */
  public $scheduled_run_date;
  /**
   * Title of the job
   *
   * @var string
   */
  public $name;
  /**
   * Description of the job
   *
   * @var string
   */
  public $description;
  /**
   * Entity of the job api call
   *
   * @var string
   */
  public $api_entity;
  /**
   * Action of the job api call
   *
   * @var string
   */
  public $api_action;
  /**
   * List of parameters to the command.
   *
   * @var text
   */
  public $parameters;
  /**
   * Is this job active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * class constructor
   *
   * @return civicrm_job
   */
  function __construct()
  {
    $this->__table = 'civicrm_job';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'domain_id', 'civicrm_domain', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Job ID') ,
          'description' => 'Job Id',
          'required' => true,
        ) ,
        'domain_id' => array(
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Job Domain') ,
          'description' => 'Which Domain is this scheduled job for',
          'required' => true,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'pseudoconstant' => array(
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'run_frequency' => array(
          'name' => 'run_frequency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Frequency') ,
          'description' => 'Scheduled job run frequency.',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'Daily',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getJobFrequency',
          )
        ) ,
        'last_run' => array(
          'name' => 'last_run',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Last Run') ,
          'description' => 'When was this cron entry last run',
          'default' => 'NULL',
        ) ,
        'scheduled_run_date' => array(
          'name' => 'scheduled_run_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Scheduled Run Date') ,
          'description' => 'When is this cron entry scheduled to run',
          'required' => false,
          'default' => 'NULL',
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Name') ,
          'description' => 'Title of the job',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Description') ,
          'description' => 'Description of the job',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'api_entity' => array(
          'name' => 'api_entity',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('API Entity') ,
          'description' => 'Entity of the job api call',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'api_action' => array(
          'name' => 'api_action',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('API Action') ,
          'description' => 'Action of the job api call',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'parameters' => array(
          'name' => 'parameters',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('API Parameters') ,
          'description' => 'List of parameters to the command.',
          'rows' => 4,
          'cols' => 60,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Job Is Active?') ,
          'description' => 'Is this job active?',
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'domain_id' => 'domain_id',
        'run_frequency' => 'run_frequency',
        'last_run' => 'last_run',
        'scheduled_run_date' => 'scheduled_run_date',
        'name' => 'name',
        'description' => 'description',
        'api_entity' => 'api_entity',
        'api_action' => 'api_action',
        'parameters' => 'parameters',
        'is_active' => 'is_active',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['job'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['job'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
