# +=========================================================================+
# || /usr/share/cipux/etc/cipux-storage.perl                               ||
# ||                                                                       ||
# || Bootstrap configuration file for the storage abstraction layer. It    ||
# || should provide the structure off LDAP object/node types.              ||
# || See manual page for more information.                                 ||
# ||                                                                       ||
# || Copyright (C) 2007 - 2009 by Christian Kuelker                        ||
# ||                                                                       ||
# || License: GNU GPL version 2 or any later version.                      ||
# ||                                                                       ||
# +=========================================================================+

my $cfg = {
    'structure' => {
        'cipux_ldap_orga_node' => {
            desc      => 'access all CipUX LDAP orga nodes',
            struc_rdn => '',
            dn_attr   => 'ou',
            filter    => '&(ou=?)(objectClass=cipuxLdapOrgaNode)',
        },
        'cipux_admin' => {
            desc      => 'access all CipUX admin nodes',
            struc_rdn => '',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxAdmin)',
        },
        'cipux_configuration' => {
            desc      => 'access all CipUX configuration nodes',
            struc_rdn => 'ou=Configuration',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxConfiguration)',
        },
        'cipux_task' => {
            desc      => 'access all CipUX task nodes',
            struc_rdn => 'ou=Task',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxTask)',
        },
        'cipux_image' => {
            desc      => 'access all CipUX image nodes',
            struc_rdn => 'ou=Image',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxImage)',
        },
        'cipux_client' => {
            desc      => 'access all CipUX client nodes',
            struc_rdn => 'ou=Machine',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxMachine)',
        },
        'cipux_room' => {
            desc      => 'access all CipUX room nodes',
            struc_rdn => 'ou=Room',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxRoom)',
        },
        'cipux_cat_module' => {
            desc      => 'access all CipUX cat_module nodes',
            struc_rdn => 'ou=CAT',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxCatModule)',
        },
        'cipux_hardware_type' => {
            desc      => 'access all CipUX hardware_type nodes',
            struc_rdn => 'ou=HardwareType',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxHardwareType)',
        },
        'cipux_image_slot' => {
            desc      => 'access all CipUX image_slot nodes',
            struc_rdn => 'ou=ImageSlot',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxImageSlot)',
        },
        'cipux_account.user' => {
            desc      => 'access all CipUX user account user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsAccount=TRUE)',
        },
        'cipux_account.group' => {
            desc      => 'access all CipUX user account group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter => '&(cn=?)(objectClass=cipuxGroup)(cipuxIsAccount=TRUE)',
        },
        'authority_account.group' => {
            desc      => 'access all CipUX entities in lisAcl auth groups',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(groupType=authority_group)',
        },
        'cipux_guest_account.user' => {
            desc      => 'access all CipUX user guest_account user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsGuestAccount=TRUE)',
        },
        'cipux_guest_account.group' => {
            desc      => 'access all CipUX user guest_account group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter =>
                '&(cn=?)(objectClass=cipuxGroup)(cipuxIsGuestAccount=TRUE)',
        },
        'cipux_examinee_account.user' => {
            desc      => 'access all CipUX user examinee_account user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsExamineeAccount=TRUE)',
        },
        'cipux_examinee_account.group' => {
            desc      => 'access all CipUX user examinee_account group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter =>
                '&(cn=?)(objectClass=cipuxGroup)(cipuxIsExamineeAccount=TRUE)',
        },
        'cipux_share.user' => {
            desc      => 'access all CipUX user share user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter => '&(uid=?)(objectClass=cipuxAccount)(cipuxIsShare=TRUE)',
        },
        'cipux_share.group' => {
            desc      => 'access all CipUX user share group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxGroup)(cipuxIsShare=TRUE)',
        },
        'cipux_global_share.user' => {
            desc      => 'access all CipUX user global_share user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsGlobalShare=TRUE)',
        },
        'cipux_global_share.group' => {
            desc      => 'access all CipUX user global_share group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter =>
                '&(cn=?)(objectClass=cipuxGroup)(cipuxIsGlobalShare=TRUE)',
        },
        'cipux_examination_share.user' => {
            desc      => 'access all CipUX user examination_share user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsExaminationShare=TRUE)',
        },
        'cipux_examination_share.group' => {
            desc => 'access all CipUX user examination_share group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter =>
                '&(cn=?)(objectClass=cipuxGroup)(cipuxIsExaminationShare=TRUE)',
        },
        'cipux_documenation_share.user' => {
            desc => 'access all CipUX user documenation_share user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter =>
                '&(uid=?)(objectClass=cipuxAccount)(cipuxIsDocumentationShare=TRUE)',
        },
        'cipux_documenation_share.group' => {
            desc => 'access all CipUX user documenation_share group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter =>
                '&(cn=?)(objectClass=cipuxGroup)(cipuxIsDocumentationShare=TRUE)',
        },
        'cipux_skel.user' => {
            desc      => 'access all CipUX user skel user nodes',
            struc_rdn => 'ou=User',
            dn_attr   => 'uid',
            filter => '&(uid=?)(objectClass=cipuxAccount)(cipuxIsSkel=TRUE)',
        },
        'cipux_skel.group' => {
            desc      => 'access all CipUX user skel group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=cipuxGroup)(cipuxIsSkel=TRUE)',
        },
        'cipux_role.group' => {
            desc      => 'access all CipUX user role group nodes',
            struc_rdn => 'ou=Group',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(groupType=authority_group)',
        },
        'cipux_netgroup' => {
            desc      => 'access all Debian-Edu netgroup nodes',
            struc_rdn => 'ou=Netgroup',
            dn_attr   => 'cn',
            filter    => '&(cn=?)(objectClass=nisNetgroup)',
        },
    },
};

return $cfg;
