#
# Author:: Tyler Cloke (<tyler@chef.io>)
# Copyright:: Copyright 2015-2016, Chef Software, Inc.
# License:: Apache License, Version 2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

class Chef
  class Knife
    # Extendable module that class_eval's common options into UserKeyEdit and ClientKeyEdit
    #
    # @author Tyler Cloke
    module KeyEditBase
      def self.included(includer)
        includer.class_eval do
          option :public_key,
                 :short => "-p FILENAME",
                 :long => "--public-key FILENAME",
                 :description => "Replace the public_key field from a file on disk. If not passed, the public_key field will not change."

          option :create_key,
                 :short => "-c",
                 :long => "--create-key",
                 :description => "Replace the public_key field with a key generated by the server. The private key will be returned."

          option :file,
                 :short => "-f FILE",
                 :long  => "--file FILE",
                 :description => "Write the private key to a file, if you requested the server to create one via --create-key."

          option :key_name,
                 :short => "-k NAME",
                 :long  => "--key-name NAME",
                 :description => "The new name for your key. Pass if you wish to update the name field of your key."

          option :expiration_date,
                 :short => "-e DATE",
                 :long  => "--expiration-date DATE",
                 :description => "Updates the expiration_date field of your key if passed. Pass in ISO 8601 fomatted string: YYYY-MM-DDTHH:MM:SSZ e.g. 2013-12-24T21:00:00Z or infinity. UTC timezone assumed."
        end
      end
    end
  end
end
