/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "PhysicalModelIO.h"
#include "StructuralComponentProperties.h"

//--------------- Constructor -------------
void StructuralComponentProperties::init() {
    myCustomProperty1 = 0;
    myCustomProperty2 = "~";

}

//--------------- destructor --------------
StructuralComponentProperties::~StructuralComponentProperties()  {
}

// --------------- xmlPrint ---------------
void StructuralComponentProperties::xmlPrint(std::ostream &o) {

    // beginning of the SC properties
    beginXML(o);

    // print all fields
    for(std::map<std::string, std::string>::iterator it = fields.begin(); it!=fields.end() ; it++)
        o << " "<<(*it).first<<"=\"" <<(*it).second<< "\"";

    // print the custom properties only if different than default value
    if (myCustomProperty1 != 0) {
        o << " myCustomProperty1=\"" << myCustomProperty1 << "\"";
    }
    if (myCustomProperty2 != "~") {
        o << " myCustomProperty2=\"" << myCustomProperty2 << "\"";
    }

    // end of the properties
    endXML(o);
}

