val frontend : Benl_frontend.frontend

val compute_transition_data :
  Benl_modules.Marshallable.t ->
  Benl_types.expr Benl_core.StringMap.t ->
  ([ `source ] Package.t *
   (string * (string * Benl_base.status)) list)
  list list * ([ `source ], [ `source ] Package.t) Package.Map.t *
  [ `binary ] Package.t Benl_modules.PAMap.t *
  ([ `source ], [ `source ] Package.Set.t) Package.Map.t * int *
  int * 'a Benl_data.S.t

val print_html_monitor :
  Benl_types.expr Benl_core.StringMap.t ->
  Template.t ->
  ([ `source ] Package.t *
   (string * (Html_types.text Tyxml.Html.wrap * Benl_base.status))
   list)
  list list ->
  'a Package.t Benl_modules.PAMap.t ->
  ('b, 'c Benl_data.S.t) Benl_data.M.t ->
  'c Benl_data.S.t ->
  bool ->
  [< Html_types.div_content_fun > `Table ] Tyxml.Html.elt option ->
  Tyxml.Html.doc

val baseurl : string ref
val has_testing_data : ('a Package.t * 'b) list list -> bool
val a_link : string -> string Tyxml.Html.wrap -> [> `A of [> `PCDATA ] ] Tyxml.Html.elt
val generated_on_text : unit -> [> `A of [> `PCDATA ] | `PCDATA ] Tyxml.Html.elt list
val check_media_dir : string -> unit
