# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import random

from balazar3.base import *


class EyeController(object):
  def find_target(self):
    targets = []
    for mobile in self.character.level.mobiles:
      if isinstance(mobile, BaseHero) and (not mobile.non_targetable) and (mobile.life > 0.0):
        dangle = abs(self.character.angle - vector2angle(mobile.i - self.character.i, mobile.j - self.character.j))
        if dangle > 180.0: dangle = 360.0 - dangle
        if (dangle <  80.0) and (mobile.get_model_name() != self.character.get_model_name()):
          targets.append(mobile)
          
    if targets:
      self.target = random.choice(targets)
    else:
      self.generators.append(self.next_with_no_target())
      
      
class GuardController(object):
  def next_with_no_target(self):
    self.character.send_action(ACTION_STOP_MOVING)
    for i in range(30): yield
    

class TurningGuardController(object):
  def next_with_no_target(self):
    self.character.send_action(ACTION_TURN_LEFT)
    yield
    yield
    yield
    yield
    self.character.send_action(ACTION_STOP_MOVING)
    for i in range(25): yield
    

class EchassianController(EyeController, TurningGuardController, BaseController):
  def __init__(self):
    self.target     = None
    self.generators = [self]
    
  def generate_actions(self):
    try:
      self.generators[-1].next()
    except StopIteration:
      del self.generators[-1]
      return self.generate_actions()
    
  def next(self):
    if not self.target: self.find_target()
    else:
      if (not self.target.level) or (self.target.life <= 0.0): self.target = None
      else: self.generators.append(self.next_with_target())
      
  def next_with_target(self):
    self.character.send_action(ACTION_GOTO_STRIKE + struct.pack("!fff", self.target.i, self.target.j, vector2angle(self.target.i - self.character.i, self.target.j - self.character.j)))
    yield
    while 1:
      if   self.character.current_action == ACTION_STRIKE:
        if self.character.animation_pos == 1:
          self.character.send_action(ACTION_STOP_MOVING)
          
      elif self.character.current_action == ACTION_STOP_MOVING:
        for i in range(20): yield
        break
      yield
