# Balazar
# Copyright (C) 2003-2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import math
import soya

class Entity(object):
  """An object selectable with the mouse."""
  can_change_parent = 0
  
  def kesako(self):
    if self.shape: return _("__kesako__%s" % self.shape.filename)
    for child in self.recursive():
      if getattr(child, "shape", None): return _("__kesako__%s" % child.shape.filename)
      
      
class Photographiable(object):
  pass


class DecorativeEntity(soya.Volume, Entity):
  can_change_parent = 1
  
  
class Discutable(object):
  discussion_radius = 5.0
  def start_discussion(self, hero): pass
  
  
class Strikeable(object):
  resistance = 4
  
  
class Terraformer(object):
  map_color        = 255, 128, 0, 255
  terraform_radius = 5.0
  


class SensitiveFloor(object):
  def character_on(self, character): pass

  
class HurtedBody(soya.World, Strikeable):
  def __init__(self, parent, body, axe):
    soya.World.__init__(self, parent)
    self.body = body
    self.move(body)
    axe %= body.parent
    axe.y = 0.0
    self.axe = axe
    body.parent.remove(body)
    self.add(body)
    body.set_xyz(0.0, 0.0, 0.0)
    
    self.angle = 0.0
    self.resistance = body.resistance
    self.uid = body.uid
    
  def begin_round(self):
    self.angle += 0.25
    nb = 1 + (self.angle // 6.2832)
    self.rotate_axe_xyz(5.0 * math.cos(self.angle) / nb, self.axe.x, self.axe.y, self.axe.z)
    
    if nb > 3:
      try: self.remove(self.body)
      except ValueError: return # Removed elsewhere
      
      self.body.set_xyz(self.x, self.y, self.z)
      self.parent.add(self.body)
      self.parent.remove(self)
      
      
class SmallHurtedBody(soya.World, Strikeable):
  def __init__(self, parent, body, axe):
    soya.World.__init__(self, parent)
    self.body = body
    self.move(body)
    axe %= body.parent
    axe.y = 0.0
    self.axe = axe
    body.parent.remove(body)
    self.add(body)
    body.set_xyz(0.0, 0.0, 0.0)
    
    self.angle = 0.0
    self.resistance = body.resistance
    self.uid = body.uid
    
  def begin_round(self):
    self.angle += 0.25
    nb = 1 + (self.angle // 6.2832)
    self.rotate_axe_xyz(1.0 * math.cos(self.angle) / nb, self.axe.x, self.axe.y, self.axe.z)
    
    if nb > 3:
      try: self.remove(self.body)
      except ValueError: return # Removed elsewhere
      
      self.body.set_xyz(self.x, self.y, self.z)
      self.parent.add(self.body)
      self.parent.remove(self)
      
      
class EjectedBody(soya.World):
  def __init__(self, parent, body, speed):
    soya.World.__init__(self, parent)
    self.solid = 0
    self.body = body
    speed %= body.parent
    speed.set_length(0.4)
    speed.y = 0.4
    self.speed = speed
    if body.parent: body.parent.remove(body)
    self.add(body)
    
  def begin_round(self):
    self.speed.y -= 0.006
    self.body.scale(0.98, 0.98, 0.98)
    if self.body.scale_x < 0.1:
      self.parent.remove(self)
      
  def advance_time(self, proportion):
    self.add_mul_vector(proportion, self.speed)
    self.body.rotate_incline(proportion * 10.0)
    
    
def display_name(subtarget):
  if not subtarget: return ""
  
  if hasattr(subtarget, "display_name"):
    if callable(subtarget.display_name): return subtarget.display_name()
    else:                                return subtarget.display_name
  else:
    if getattr(subtarget, "shape", None):
      display_name = _("__shape__%s" % subtarget.shape.filename)
      if display_name[0] == "_": return ""
      return display_name
    
  target = subtarget
  while target and not isinstance(target, Entity): target = target.parent
  
  if hasattr(target, "display_name"):
    if callable(target.display_name): return target.display_name()
    else:                             return target.display_name
  else:
    if getattr(target, "shape", None):
      display_name = _("__shape__%s" % target.shape.filename)
      if display_name[0] == "_": return ""
      return display_name

    if isinstance(target, soya.World):
      for i in target.recursive():
        if getattr(i, "shape", None):
          display_name = _("__shape__%s" % i.shape.filename)
          if display_name.startswith("_"): return ""
          return display_name
        
  return ""
