#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from msrestazure.azure_operation import AzureOperationPoller
import uuid

from .. import models


class VpnConnectionOperations(object):
    """VpnConnectionOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def create_or_update(
            self, resource_group_name, deployment_name, connection_type, virtual_network_gateway_connection_name, vnet_gateway1_id, content_version=None, express_route_circuit2_id=None, local_gateway2_id=None, location=None, routing_weight=10, shared_key="none", vnet_gateway2_id=None, custom_headers=None, raw=False, **operation_config):
        """
        Create or update a virtual machine.

        :param resource_group_name: The name of the resource group. The name
         is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param connection_type: Connection type. Possible values include:
         'IPSec', 'Vnet2Vnet', 'ExpressRoute'
        :type connection_type: str or :class:`connectionType
         <vpnconnectioncreationclient.models.connectionType>`
        :param virtual_network_gateway_connection_name: Connection name.
        :type virtual_network_gateway_connection_name: str
        :param vnet_gateway1_id: Connect from this gateway to another gateway
         or express route circuit.
        :type vnet_gateway1_id: str
        :param content_version: If included it must match the ContentVersion
         in the template.
        :type content_version: str
        :param express_route_circuit2_id: Connect to this express route
         circuit from vnet gateway 1 using connection type ExpressRoute.
        :type express_route_circuit2_id: str
        :param local_gateway2_id: Connect to this local gateway from vnet
         gateway 1 using connection type IPSec.
        :type local_gateway2_id: str
        :param location: Location for resource.
        :type location: str
        :param routing_weight: Connection routing weight.
        :type routing_weight: int
        :param shared_key: IPSec shared key.
        :type shared_key: str
        :param vnet_gateway2_id: Connect to this vnet gateway from vnet
         gateway 1 using connection type Vnet2Vnet.
        :type vnet_gateway2_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :rtype:
         :class:`AzureOperationPoller<msrestazure.azure_operation.AzureOperationPoller>`
         instance that returns :class:`DeploymentExtended
         <default.models.DeploymentExtended>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        parameters = models.DeploymentVpnConnection(content_version=content_version, connection_type=connection_type, express_route_circuit2_id=express_route_circuit2_id, local_gateway2_id=local_gateway2_id, location=location, routing_weight=routing_weight, shared_key=shared_key, virtual_network_gateway_connection_name=virtual_network_gateway_connection_name, vnet_gateway1_id=vnet_gateway1_id, vnet_gateway2_id=vnet_gateway2_id)

        # Construct URL
        url = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'deploymentName': self._serialize.url("deployment_name", deployment_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'DeploymentVpnConnection')

        # Construct and send request
        def long_running_send():

            request = self._client.put(url, query_parameters)
            return self._client.send(
                request, header_parameters, body_content, **operation_config)

        def get_long_running_status(status_link, headers=None):

            request = self._client.get(status_link)
            if headers:
                request.headers.update(headers)
            return self._client.send(
                request, header_parameters, **operation_config)

        def get_long_running_output(response):

            if response.status_code not in [200, 201]:
                exp = CloudError(response)
                exp.request_id = response.headers.get('x-ms-request-id')
                raise exp

            deserialized = None

            if response.status_code == 200:
                deserialized = self._deserialize('DeploymentExtended', response)
            if response.status_code == 201:
                deserialized = self._deserialize('DeploymentExtended', response)

            if raw:
                client_raw_response = ClientRawResponse(deserialized, response)
                return client_raw_response

            return deserialized

        if raw:
            response = long_running_send()
            return get_long_running_output(response)

        long_running_operation_timeout = operation_config.get(
            'long_running_operation_timeout',
            self.config.long_running_operation_timeout)
        return AzureOperationPoller(
            long_running_send, get_long_running_output,
            get_long_running_status, long_running_operation_timeout)
