#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeploymentVpnConnection(Model):
    """
    Deployment operation parameters.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar uri: URI referencing the template. Default value:
     "https://azuresdkci.blob.core.windows.net/templatehost/CreateVpnConnection_2016-08-08/azuredeploy.json"
     .
    :vartype uri: str
    :param content_version: If included it must match the ContentVersion in
     the template.
    :type content_version: str
    :param connection_type: Connection type. Possible values include:
     'IPSec', 'Vnet2Vnet', 'ExpressRoute'
    :type connection_type: str or :class:`connectionType
     <vpnconnectioncreationclient.models.connectionType>`
    :param express_route_circuit2_id: Connect to this express route circuit
     from vnet gateway 1 using connection type ExpressRoute.
    :type express_route_circuit2_id: str
    :param local_gateway2_id: Connect to this local gateway from vnet gateway
     1 using connection type IPSec.
    :type local_gateway2_id: str
    :param location: Location for resource.
    :type location: str
    :param routing_weight: Connection routing weight. Default value: 10 .
    :type routing_weight: int
    :param shared_key: IPSec shared key. Default value: "none" .
    :type shared_key: str
    :param virtual_network_gateway_connection_name: Connection name.
    :type virtual_network_gateway_connection_name: str
    :param vnet_gateway1_id: Connect from this gateway to another gateway or
     express route circuit.
    :type vnet_gateway1_id: str
    :param vnet_gateway2_id: Connect to this vnet gateway from vnet gateway 1
     using connection type Vnet2Vnet.
    :type vnet_gateway2_id: str
    :ivar mode: Gets or sets the deployment mode. Default value:
     "Incremental" .
    :vartype mode: str
    """ 

    _validation = {
        'uri': {'required': True, 'constant': True},
        'connection_type': {'required': True},
        'virtual_network_gateway_connection_name': {'required': True},
        'vnet_gateway1_id': {'required': True},
        'mode': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'uri': {'key': 'properties.templateLink.uri', 'type': 'str'},
        'content_version': {'key': 'properties.templateLink.contentVersion', 'type': 'str'},
        'connection_type': {'key': 'properties.parameters.connectionType.value', 'type': 'connectionType'},
        'express_route_circuit2_id': {'key': 'properties.parameters.expressRouteCircuit2Id.value', 'type': 'str'},
        'local_gateway2_id': {'key': 'properties.parameters.localGateway2Id.value', 'type': 'str'},
        'location': {'key': 'properties.parameters.location.value', 'type': 'str'},
        'routing_weight': {'key': 'properties.parameters.routingWeight.value', 'type': 'int'},
        'shared_key': {'key': 'properties.parameters.sharedKey.value', 'type': 'str'},
        'virtual_network_gateway_connection_name': {'key': 'properties.parameters.virtualNetworkGatewayConnectionName.value', 'type': 'str'},
        'vnet_gateway1_id': {'key': 'properties.parameters.vnetGateway1Id.value', 'type': 'str'},
        'vnet_gateway2_id': {'key': 'properties.parameters.vnetGateway2Id.value', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
    }

    uri = "https://azuresdkci.blob.core.windows.net/templatehost/CreateVpnConnection_2016-08-08/azuredeploy.json"

    mode = "Incremental"

    def __init__(self, connection_type, virtual_network_gateway_connection_name, vnet_gateway1_id, content_version=None, express_route_circuit2_id=None, local_gateway2_id=None, location=None, routing_weight=10, shared_key="none", vnet_gateway2_id=None):
        self.content_version = content_version
        self.connection_type = connection_type
        self.express_route_circuit2_id = express_route_circuit2_id
        self.local_gateway2_id = local_gateway2_id
        self.location = location
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.virtual_network_gateway_connection_name = virtual_network_gateway_connection_name
        self.vnet_gateway1_id = vnet_gateway1_id
        self.vnet_gateway2_id = vnet_gateway2_id
