#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from msrestazure.azure_operation import AzureOperationPoller
import uuid

from .. import models


class ExpressRoutePeeringOperations(object):
    """ExpressRoutePeeringOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def create_or_update(
            self, resource_group_name, deployment_name, bandwidth_in_mbps, circuit_name, peer_asn, peering_location, primary_peer_address_prefix, secondary_peer_address_prefix, service_provider_name, vlan_id, content_version=None, location=None, peering_type="AzurePrivatePeering", sku_family="MeteredData", sku_tier="Standard", tags=None, custom_headers=None, raw=False, **operation_config):
        """
        Create or update a virtual machine.

        :param resource_group_name: The name of the resource group. The name
         is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param bandwidth_in_mbps: Bandwidth in Mbps of the circuit being
         created. It must exactly match one of the available bandwidth offers
         List ExpressRoute Service Providers API call.
        :type bandwidth_in_mbps: int
        :param circuit_name: Name of the ExpressRoute circuit
        :type circuit_name: str
        :param peer_asn: The autonomous system number of the
         customer/connectivity provider.
        :type peer_asn: int
        :param peering_location: Name of the peering location and not the ARM
         resource location. It must exactly match one of the available
         peering locations from List ExpressRoute Service Providers API call.
        :type peering_location: str
        :param primary_peer_address_prefix: /30 subnet used to configure IP
         addresses for interfaces on Link1.
        :type primary_peer_address_prefix: str
        :param secondary_peer_address_prefix: /30 subnet used to configure IP
         addresses for interfaces on Link2.
        :type secondary_peer_address_prefix: str
        :param service_provider_name: Name of the ExpressRoute Service
         Provider. It must exactly match one of the Service Providers from
         List ExpressRoute Service Providers API call.
        :type service_provider_name: str
        :param vlan_id: Specifies the identifier that is used to identify the
         customer.
        :type vlan_id: int
        :param content_version: If included it must match the ContentVersion
         in the template.
        :type content_version: str
        :param location: Location for resources.
        :type location: str
        :param peering_type: BGP peering type for the Circuit.
        :type peering_type: str
        :param sku_family: Chosen SKU family of ExpressRoute circuit.
        :type sku_family: str
        :param sku_tier: Chosen SKU Tier of ExpressRoute circuit.
        :type sku_tier: str
        :param tags: Tags object.
        :type tags: object
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :rtype:
         :class:`AzureOperationPoller<msrestazure.azure_operation.AzureOperationPoller>`
         instance that returns :class:`DeploymentExtended
         <default.models.DeploymentExtended>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        parameters = models.DeploymentExpressRoutePeering(content_version=content_version, bandwidth_in_mbps=bandwidth_in_mbps, circuit_name=circuit_name, location=location, peer_asn=peer_asn, peering_location=peering_location, peering_type=peering_type, primary_peer_address_prefix=primary_peer_address_prefix, secondary_peer_address_prefix=secondary_peer_address_prefix, service_provider_name=service_provider_name, sku_family=sku_family, sku_tier=sku_tier, tags=tags, vlan_id=vlan_id)

        # Construct URL
        url = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'deploymentName': self._serialize.url("deployment_name", deployment_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'DeploymentExpressRoutePeering')

        # Construct and send request
        def long_running_send():

            request = self._client.put(url, query_parameters)
            return self._client.send(
                request, header_parameters, body_content, **operation_config)

        def get_long_running_status(status_link, headers=None):

            request = self._client.get(status_link)
            if headers:
                request.headers.update(headers)
            return self._client.send(
                request, header_parameters, **operation_config)

        def get_long_running_output(response):

            if response.status_code not in [200, 201]:
                exp = CloudError(response)
                exp.request_id = response.headers.get('x-ms-request-id')
                raise exp

            deserialized = None

            if response.status_code == 200:
                deserialized = self._deserialize('DeploymentExtended', response)
            if response.status_code == 201:
                deserialized = self._deserialize('DeploymentExtended', response)

            if raw:
                client_raw_response = ClientRawResponse(deserialized, response)
                return client_raw_response

            return deserialized

        if raw:
            response = long_running_send()
            return get_long_running_output(response)

        long_running_operation_timeout = operation_config.get(
            'long_running_operation_timeout',
            self.config.long_running_operation_timeout)
        return AzureOperationPoller(
            long_running_send, get_long_running_output,
            get_long_running_status, long_running_operation_timeout)
