/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.Cache;
import org.cojen.util.SoftValueCache;
import org.cojen.util.WeakIdentityCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickConstructorGenerator {
    private static Cache<Class<?>, Cache<Class<?>, Object>> cCache = new WeakIdentityCache(17);

    public static synchronized <F> F getInstance(final Class<?> objectType, final Class<F> factory) {
        Object instance;
        Cache<Class<?>, Object> innerCache = cCache.get(factory);
        if (innerCache == null) {
            innerCache = new SoftValueCache(5);
            cCache.put(factory, innerCache);
        }
        if ((instance = innerCache.get(objectType)) != null) {
            return (F)instance;
        }
        if (objectType == null) {
            throw new IllegalArgumentException("No object type");
        }
        if (factory == null) {
            throw new IllegalArgumentException("No factory type");
        }
        if (!factory.isInterface()) {
            throw new IllegalArgumentException("Factory must be an interface");
        }
        final Cache<Class<?>, Object> fInnerCache = innerCache;
        return (F)AccessController.doPrivileged(new PrivilegedAction<F>(){

            @Override
            public F run() {
                return QuickConstructorGenerator.getInstance(fInnerCache, objectType, factory);
            }
        });
    }

    private static synchronized <F> F getInstance(Cache<Class<?>, Object> innerCache, Class<?> objectType, Class<F> factory) {
        Object instance;
        int index;
        String prefix = objectType.getName();
        if (prefix.startsWith("java.") && (index = prefix.lastIndexOf(46)) > 0) {
            prefix = prefix.substring(index + 1);
        }
        RuntimeClassFile cf = null;
        for (Method method : factory.getMethods()) {
            Constructor<?> ctor;
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            try {
                ctor = objectType.getConstructor(method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            if (!method.getReturnType().isAssignableFrom(objectType)) {
                throw new IllegalArgumentException("Method return type must be \"" + objectType.getName() + "\" or supertype: " + method);
            }
            Class<?>[] methodExTypes = method.getExceptionTypes();
            block6: for (Class<?> ctorExType : ctor.getExceptionTypes()) {
                if (RuntimeException.class.isAssignableFrom(ctorExType) || Error.class.isAssignableFrom(ctorExType)) continue;
                for (Class<?> methodExType : methodExTypes) {
                    if (methodExType.isAssignableFrom(ctorExType)) continue block6;
                }
                throw new IllegalArgumentException("Method must declare throwing \"" + ctorExType.getName() + "\": " + method);
            }
            if (cf == null) {
                cf = new RuntimeClassFile(prefix, null, objectType.getClassLoader());
                cf.setSourceFile(QuickConstructorGenerator.class.getName());
                cf.setTarget("1.5");
                cf.addInterface(factory);
                cf.markSynthetic();
                cf.addDefaultConstructor();
            }
            CodeBuilder b = new CodeBuilder(cf.addMethod(method));
            b.newObject(TypeDesc.forClass(objectType));
            b.dup();
            int count = b.getParameterCount();
            for (int i = 0; i < count; ++i) {
                b.loadLocal(b.getParameter(i));
            }
            b.invoke(ctor);
            b.returnValue(TypeDesc.OBJECT);
        }
        if (cf == null) {
            throw new IllegalArgumentException("No methods in factory to implement");
        }
        try {
            instance = cf.defineClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InstantiationException e) {
            throw new UndeclaredThrowableException(e);
        }
        innerCache.put(objectType, instance);
        return (F)instance;
    }
}

