/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:01:12 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.DebugGraphics;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.CSCSAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class CSCSAlgorithm_ESTest extends CSCSAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues((-5), 811, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      float[] floatArray0 = new float[3];
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(2, 2, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      CSCSAlgorithm cSCSAlgorithm0 = null;
      try {
        cSCSAlgorithm0 = new CSCSAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CSCSAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Integer integer0 = cSCSAlgorithm0.getDefaultStepSize(1628);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals(24, (int)integer0);
      assertNotNull(integer0);
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Integer integer0 = cSCSAlgorithm0.getDefaultStepSize(5);
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertNull(integer0);
      assertTrue(cSCSAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Integer integer0 = cSCSAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      char[] charArray0 = new char[4];
      Short short0 = new Short((short) (-3417));
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, (Integer) null);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Integer integer0 = cSCSAlgorithm0.getDefaultMaxWindowSize();
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Integer integer0 = cSCSAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals(500, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Reverse Corrected Scaled Chi Square");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      cSCSAlgorithm0.getValues(2, 641, floatArray0);
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertTrue(cSCSAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      char[] charArray0 = new char[4];
      Short short0 = new Short((short) (-3417));
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, (Integer) null);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues((short) (-3417), 0, (float[]) null);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Reverse Corrected Scaled Chi Square");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      cSCSAlgorithm0.getValues(2, 641, floatArray0);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals("Reverse Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Float float0 = cSCSAlgorithm0.getMaximumInternal();
      assertEquals(1000.0F, (float)float0, 0.01F);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      Float float0 = cSCSAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getAverage();
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertTrue(cSCSAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      DebugGraphics debugGraphics0 = new DebugGraphics();
      Color[] colorArray0 = new Color[7];
      cSCSAlgorithm0.drawLegend((Graphics) debugGraphics0, 1, 2, colorArray0);
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals("Reverse Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Reverse Corrected Scaled Chi Square");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getValueCount();
  }
}
