# Reply to errors and distortions in Phil Mitchinson's **_Marxism and direct
action_**

Phil Mitchinson essay [ **Marxism and direct
action**](http://www.marxist.com/Theory/direct_action.html) attempts to
provide a "Marxist" (i.e. Leninist/Trotskyist) critique of the current "Direct
Action" based groups which came to notice at various demonstrations across the
world -- most famously in Seattle, November 1999. He, correctly, links these
groups and currents with anarchism. However, his "critique" is nothing but a
self-contradictory collection of false assertions, lies and nonsense, as we
shall prove (indeed, his "critique" seems more the product of envy at
anarchist influence in these movements than the product of scholarship or
objectivity). That is why we have decided to reply to his article -- it gives
us an ideal possibility to indicate the depths to which some Marxists will
swoop to distort anarchist politics and movements.

## 1\. How does Mitchinson impoverish the politics of the direct action
groups?

He begins by noting that the _"recent anti-capitalist demonstrations have
brought together many different groups protesting against the destruction of
the environment, racism, the exploitation of the third world, and also many
ordinary young people protesting at the state of things in general. They have
certainly shattered the myth that everyone is happy and that the capitalist
system is accepted as the only possible form of society."_ Of course, this is
correct. What he fails to mention is that these demonstrations and groups
managed to do this **without** the "guidance" of any Leninist party -- indeed,
the vanguard parties are noticeable by their absence and their frantic efforts
to catch up with these movements. This, of course, is not the first time this
has happened. Looking at every revolution we discover the "revolutionary"
parties either playing no role in their early stages or a distinctly counter-
productive role.

He states that _"[a]ll around us we see the misery this system causes. Famine,
war, unemployment, homelessness and despair, these are the violent acts that
the system perpetrates against millions every day."_ However, as much as these
aspects of capitalism are terrible, the anti-capitalist revolt expressed by
many within the direct action groups is much wider than this (standard)
leftist list. The movements, or at least parts of them, have a much more
radical critique of the evils of capitalism -- one that bases it self on
abolishing alienation, domination, wage slavery, oppression, exploitation, the
spiritual as well as material poverty of everyday life, by means of self-
management, autonomy, self-organisation and direct action. They raise the
possibility of playful, meaningful, empowering and productive self-activity to
replace _"tedious, over-tiring jobs"_ as well as the vision of a libertarian
communist (i.e. moneyless, stateless) society. Mitchinson's account of the
movements he is trying to critique is as poverty stricken intellectually as
the capitalist system these movements are challenging. Leninists like
Mitchinson, instead of a swallowing a dose of humility and learning from the
very different ways this new wave of protest is being framed, are trying to
squeeze the protest into their own particular one-dimensional model of
revolution. Being unable to understand the movements he is referring to, he
pushes their vision into the narrow confines of his ideology and distorts it.

He goes on to state that _"[w]itnessing and experiencing this destruction and
chaos, young people everywhere are driven to protest."_ Of course, anyone who
is part of these movements will tell you that a wide cross-section of age
groups are involved, not just _"young people."_ However, Mitchinson's comments
on age are not surprising -- ever since Lenin, Bolshevik inspired Marxists
have attributed other, more radical, political theories, analyses and visions
to the alleged youth of those who hold these opinions (in spite of the facts).
In other words, these ideas, they claim, are the produce of immaturity,
inexperience and youth and will, hopefully, be grown out of. Just as many
parents mutter to themselves that their anarchist (or socialist, homosexual,
whatever) children will "grow out of it", Lenin and his followers like
Mitchinson consider themselves as the wiser, older relations (perhaps a
friendly Uncle or a Big Brother?) of these "young" rebels and hope they will
"grow out of" their infantile politics.

The word patronising does not do Mitchinson justice!

## 2\. Does anarchism _"juxtapose"_ theory and action?

Now Mitchinson launches into his first strawman of his essay. He asserts:

> _"However, the idea of getting involved in a political organisation is a
turn off for many, who understandably want to do something, and do something
now. In reality, the attempt to juxtapose organisation, discussion, and debate
with 'direct action' is pure sophistry."  
>  _

We are not aware of any anarchist or direct action group which does not
discuss and debate their actions, the rationale of their actions and the aims
of their actions. These demonstrations that _"young people"_ apparently turn
up at are, in fact, organised by groups who have meetings, discuss their
ideas, their objectives, their politics, and so on. That much should be
obvious. In reality, it is Mitchinson who expresses _"pure sophistry,"_ not
the _"many"_ who he claims act without thinking. And, of course, he fails to
mention the two days of meetings, discussion and debate which took place the
Saturday/Sunday before the May Day actions in London. To mention the May Day
2000 conference would confuse the reader with facts and so goes unmentioned.

He then asserts that the _"ideas of Marxism are not the subject of academic
study, they are precisely a guide to action."_ Of course, we have to point out
here that the Marxist Parties Mitchinson urges us to build did not take part
in organising the actions he praises (a few members of these parties did come
along, on some of them, to sell papers, of course, but this is hardly a
"vanguard" role). In general, the vanguard parties were noticeable by their
absence or, **at best**, their lack of numbers and involvement. If we judge
people by what they do, rather than what they say (as Marx urged), then we
must draw the conclusion that the Marxism of Mitchinson is a guide to inaction
rather than action.

Mitchinson continues by stating Marxists _"are all in favour of action, but it
must be clearly thought out, with definite aims and objectives if it is to
succeed. Otherwise we end up with directionless action."_ It would be impolite
to point out that no anarchist or member of a direct action organisation would
disagree with this statement. Every anti-capitalist demonstration has had a
definite aim and objective, was clearly thought out and organised. It did not
"just happen." Mitchinson presents us with a strawman so fragile that even a
breeze of reality would make it disintegrate.

The question is, of course, what kind of organisation do we create, how do we
determine our aims and objectives. That is the key question, one that
Mitchinson hides behind the strawman of organisation versus non-organisation,
planned action versus _"directionless action."_ To state it bluntly, the
question is actually one of do we organise in an authoritarian manner or a
libertarian manner, not whether or not we organise. Mitchinson may not see the
difference (in which case he thinks all organisation is "authoritarian") but
for anarchists and members of direct action groups the difference is vital.

He goes on to state:

> _"Furthermore without political organisation who decides what action is to
be taken, when and where? There can be no greater direct action than the
seizing of control over our own lives by the vast majority of society. In that
act lies the essence of revolution. Not just an aimless 'direct action' but
mass, democratic and conscious action, the struggle not just against
capitalism, but for a new form of society, socialism."  
>  _

Again Mitchinson presents us with the strawman of _"conscious"_ action verses
_"aimless"_ action. As noted above, the anti-capitalist demonstrations
**were** organised -- non-hierarchical groups decided collectively what action
was to be organised, when and where. The real question is not organisation
versus non-organisation but rather authoritarian versus libertarian
organisation. Either decision making from the bottom up or decision making
from the top-down. As for there bring _"no greater direct action"_ than
revolution, well, anarchists have been saying that for over one hundred years
-- we don't need a Marxist to tell us our own ideas!

## 3\. How does Mitchinson distort the London May Day demo?

He then gets to the crux of the issue -- _"So, what comes next?"_ He goes on
to assert:

> _"The organisers of the demo tell us this was not a protest in order to
secure changes, reforms apparently are a waste of time. No, simply by
participating in what they call the 'carnival' we become better people, and
eventually more and more people will participate, until a critical mass is
reached and we all ignore capitalism, don't pay our bills, until they go away.
What an infantile flight of fancy!"  
>  _

Yes, indeed, what an infantile flight of fancy! However, the flight is purely
Mitchinson's. No one in RTS (or any other anarchist) makes such a claim. Yes,
RTS urged people to take part in a carnival -- as they argue, _"[m]any of the
great moments of revolutionary history were carnivalesque . . . But we are not
waiting for these moments of carnivalesque revolution, we are trying to merge
them into every moment of everyday life. We cannot live on one-off days, a
letting of stream, safety values for society enabling life to return to normal
the next day or for hierarchical domination to return, as did in so many
historical revolutions. Revolution is not an act but a process and carnival
can prepare us for this process."_ [**Maybe**, p. 9] Thus _"carnival"_ is
**not** seen as an end to itself (as Mitchinson asserts) but rather an aid to
the creation of a revolutionary movement. Mitchinson confuses a celebration of
May Day with an insurrection! In the words of **Maybe**:

> _"And although Mayday is just one day, it seeks to incite continuous
creativity and action towards a radical remaking of everyday life. Steeped in
a history of daily struggle, of 'day in day out' organising for social change,
but pulsating with the celebration of renewal and fresh hope that returns with
the coming of summer. Mayday will always be a pivotal moment."_ [**Maybe**, p.
5]

**Maybe** is clear -- we need to organise the daily struggle and enjoy ourselves while we are at it. Mitchinson' distortion of that message is pitiful.

## 4\. Do anarchists really think _"the bosses will do nothing to defend their
system"_?

He continues:

> _"The genuine intentions of those protesting is not open to question.
However, the way to hell is paved with many such good intentions. Are we
really to believe that whilst we all 'place ourselves outside of capitalism',
the bosses will do nothing to defend their system? This ostrich like tactic of
burying our heads in the sand until they go away is not serious. Nor is it
action. In reality, it is irresponsible, indirect inaction."  
>  _

The comment about _"indirect inaction"_ is somewhat funny coming from a
political tendency which did not produce a movement of the importance of
Seattle 1999 and is now trying to recruit from it. But it would be interesting
to discover in which anarchist work comes the notion that we do not think the
bosses will not defend their system. Yes, Lenin did claim that anarchists
would _"lay down their arms"_ after a revolution, but as Murray Bookchin
notes, anarchists are _"not so naive as to believe anarchism could be
established overnight. In imputing this notion to Bakunin, Marx and Engels
wilfully distorted the Russian anarchist's views. Nor did the anarchists . . .
believe that the abolition of the state involved 'laying down arms'
immediately after the revolution. . ."_ [**Post-Scarcity Anarchism**, p. 213]
Bakunin, for example, thought the _"Commune would be organised by the standing
federation of the Barricades"_ and that _"the federation of insurgent
associations, communes and provinces . . . [would] organise a revolutionary
force capable of defeating reaction . . . it is the very fact of the expansion
and organisation of the revolution for the purpose of self-defence among the
insurgent areas that will bring about the triumph of the revolution."_
[**Michael Bakunin: Selected Writings**, p. 170 and p. 171]

Moreover, RTS actions have continually came into conflict with the state and
its forces of defence. Mitchinson seems to think that the participants of RTS
and its demonstrations are incapable of actually understanding and learning
from their experiences -- they have seen and felt the capitalist system
defending itself. Anyone on the J18, N30, A16 or M1 demos or just watching
them on TV would have seen the capitalist system defending itself with vigour
-- and the protestors **fighting back.** Rather than acknowledge the obvious,
Mitchinson asserts nonsense. The only person burying their head in the sand is
Mitchinson if he ignores the experiences of his own senses (and the basic
principles of materialism) in favour of an ideological diatribe with no basis
in reality.

What **is** _"irresponsible"_ is misrepresenting the viewpoints of your
enemies and expecting them not to point our your errors.

## 5\. How does Mitchinson misrepresent anarchist organisation?

Mitchinson now moves onto the real enemy, anarchism. He asserts that:

> _"Anarchist organisations have always hidden behind a facade of 'self-
organisation'. They claim to have no leaders, no policy etc. Yet who decides?"  
>  _

Yes, anarchist groups claim to have no leaders but they do not claim to be
without policies. Anyone with any comprehension of anarchist theory and
history would know this (just one example, Bakunin argued that we needed to
establish _"a genuine workers' program -- the policy of the International
[Workers Association]"_ [_"The Policy of the International"_, **The Basic
Bakunin**, p. 100]).

Mitchinson asks the question, if we do not have leaders, _"who decides?"_ That
in itself exposes the authoritarian nature of his politics and the Bolshevik
style party. He obviously cannot comprehend that, without leaders deciding
things for us, we manage our own affairs -- we decide the policy of our
organisations collectively, by the direct democracy of the membership.
Forgetting his early comment of that there is _"no greater direct action than
the seizing of control over our own lives by the vast majority of society,"_
he now asks how the vast majority of society can seize control over our own
lives without leaders to tell us what to do!

Anarchists reject the idea of leaders -- instead we argue for the
_**"leadership of ideas."**_ As we discuss this concept in [section
J.3.6](secJ3.html#secj36) and so will not do so here. However, the key concept
is that anarchists seek to spread their ideas by discussing their politics
**as equals** in popular organisations and convincing the mass assemblies of
these bodies by argument. Rather than using these bodies to be elected to
positions of power (i.e. leadership as it is traditionally understood)
anarchists consider it essential that power remains in the hands of the base
of an organisation and argue that the policies of the organisation be decided
by the member directly in assemblies and co-ordinated by conferences of
mandated, recallable delegates (see [section A.2.9](secA2.html#seca29) for
more discussion).

This is to be expected, of course, as anarchists believe that a free society
can only be created by organisations which reflect the principles of that
society. Hence we see policies being made by those affected by them and oppose
attempts to turn self-managed organisations into little more than vehicles to
elect "leaders." A free society is a self-managed one and can only be created
by self-management in the class struggle or revolutionary process. All that
revolutionaries should do is try and influence the decisions these
organisations make by discussing our ideas with their membership -- simply as
any other member could in the mass assemblies the organisation is built upon.
Any attempt by revolutionaries to seize power upon behalf of these
organisations means destroying their revolutionary potential and the
revolution itself by replacing the participation of all with the power of a
few (the party).

Thus anarchist theory and practice is very clear on the question _"who
decides"_ \-- it is those who are affected by the question via group
assemblies and conferences of mandated, recallable delegates. Rather than have
_"no policy,"_ policy in an anarchist organisation is decided directly by the
membership. Without _"leaders"_ \-- without power delegated into the hands of
a few -- who else **could** make the decisions and policy? That Mitchinson
cannot comprehend this implies that he cannot envision a society without a few
telling the many what to do.

He continues:

> _"If there was no leadership and no policy then there could be no action of
any kind. The recent demonstrations have been highly organised and co-
ordinated on an international scale. Good, so it should be. However, without
organisation and democracy no-one, except a clique at the top, has any say in
why, where and when. Such a movement will never bring international capital
trembling to its knees."  
>  _

Firstly, we must point out that these demonstrations which have spread like
wild-fire across the world have, most definitely, made international capital
nervous. Secondly, we must point out that no Leninist vanguards were involved
in organising them (a few members turned up to sell papers later, once their
significance had registered with the party leadership). Thirdly, we must point
out that no Leninist vanguard has made _"international capital"_ tremble in
the knees for quite a few decades -- since 1917, only Stalinist vanguards have
had any effect (and, of course, _"international capital"_ soon realised they
could work with the Bolsheviks and other "Communist" leaders as one ruling
elite with another). It seems somewhat ironic that a Leninist, whose movement
was noticeable in its absence, mocks the first movement to scare the ruling
class for nearly 30 years.

Secondly, we must note that the policy decided upon by the multitude of groups
across the world was decided upon by the members of those groups. They
practised organisation and **direct** democracy to make their policy decisions
and implement them. Given that Mitchinson wonders how people can make
decisions without leaders, his comments about rule by _"a clique at the top"_
are somewhat ironic. As the history of the Russian Revolution indicates, a
highly centralised state system (which mimics the highly centralised party)
soon results in rule by the top party officials, not by the mass of people.

Mitchinson again decides to flog his fallacy of organisation versus non-
organisation:

> _"One of the best known anarchist groups in Britain, Reclaim the Streets,
save the game away in their spoof Mayday publication, 'Maybe'. Incidentally,
who wrote these articles, who decided what went in and what didn't, who edited
it, where did the money come from? Our intention here is not to accuse them of
dodgy financing - simply to point out that this 'no leaders' stuff is a self-
organised myth."  
>  _

It states who put together **MayDay** on page 5 of the paper. It was _"an
organic group of 'guerrilla gardeners'"_ \-- in other words, members of
**Reclaim the Streets** who desired to produce the paper for that event. These
people would have joined the group producing it via the weekly RTS open
meetings and would have been held accountable to that same open meeting. No
great mystery there -- if you have even the slightest vision of how a non-
hierarchical organisation works. Rather than being a _"myth"_, RTS shows that
we do not need to follow leaders -- instead we can manage our own
organisations directly and freely participate in projects organised via the
main open meeting. Writing articles, editing, and so on are not the work of
_"leaders"_ \-- rather they are simply tasks that need doing. They do not
imply a leadership role -- if they did then every hack journalist is a
_"leader."_

He continues to attack what he cannot understand:

> _"On page 20 they announce 'Reclaim the streets is non-hierarchical,
spontaneous and self-organised. We have no leaders, no committee, no board of
directors, no spokes people. There is no centralised unit for decision making,
strategic planning and production of ideology. There is no membership and no
formalised commitment. There is no master plan and no pre-defined agenda.' _

>

> _"There are two problems here. Firstly who is 'we', who made the above
statement, and who decided it. Secondly, if it were true, it would not be
something of which to be proud. Whether you like it or not, there is no way
the capitalist system will ever be overthrown by such a haphazard and slipshod
method."_

Taking the first issue, _"who is 'we,' who made the above statement, and who
decided it."_ Why, it is the membership of RTS -- decided via their weekly
open meeting (as mentioned on that page). That Mitchinson cannot comprehend
this says a lot about his politics and vision. He cannot comprehend self-
management, direct democracy. He seems not to be able to understand that
groups can make decisions collectively, without having to elect leaders to
make any decisions for them.

Taking the second issue, it is clear that Mitchinson fails to understand the
role of RTS (and other anarchist groups). Anarchists do not try to overthrow
capitalism **on behalf of others** \-- they urge them to overthrow it
themselves, by their own direct action. The aim of groups like RTS is to
encourage people to take direct action, to fight the powers that be and, in
the process, create their own organs of self-management and resistance. Such a
process of working class self-activity and self-organisation in struggle is
the starting process of every revolution. People in struggle create their own
organisations -- such as soviets (workers' councils), factory committees,
community assemblies -- through which they start to manage their own affairs
and, hopefully, overthrow the state and abolish capitalism. It is not the task
of RTS to overthrow capitalism, it is the task of the whole population.

Moreover, many anarchists do see the need for a specific anarchist
organisation -- three national federations exist in the UK, for example. RTS
does not need to organise in this fashion simply because such groups
**already** exist. It is not its role -- its role is a means to encourage
self-activity and direct action as well as raising libertarian ideas in a
popular manner. For more "serious" political organisation, people can and do
turn to other anarchist groups and federations.

The street carnival principle of RTS is precisely the type of organising
anarchists excel at -- namely fun organising that catches the fun and
excitement of popular direct action and, most importantly, **gets people out
on the streets** \-- something Marxists have failed to do very well (if at
all). It's a small step from organising a street carnival to further, "more
serious" organising. Anarchist revolution is about bringing joy back into
human lives, not endless (and often dishonest) polemics on the ideas of long
dead philosophers. Rather, it is about creating a philosophy which, while
inspired by past thinkers, is not subservient to them and aims to base itself
on **current** struggles and needs rather than past ones. It is also about
building a new political culture, one that is popular, active, street-based
(versus ivory-tower elitist), and above all, fun. Only this way can we catch
the imagination of everyday people and move them from resigned apathy to
active resistance. The Marxists have tried their approach, and it has been a
resounding failure -- everyday people consider Marxism at best irrelevant, and
at worst, inhuman and lifeless. Fortunately, anarchists are not following the
Marxist model of organising, having learned from history

Thus Mitchinson fails to understand the role of RTS or its position in the UK
anarchist movement.

He then asserts:

> _"There is no theory, no coherent analysis of society, no alternative
programme. To brag of a lack of direction, a lack of purpose and a lack of
coherence, in the face of such a highly organised and brutal enemy as
international capital, is surely the height of irresponsibility."  
>  _

Firstly, anyone reading **Maybe** or other RTS publications will quickly see
there is theory, coherent analysis and an alternative vision. As Mitchinson
has obviously read **Maybe** we can only assume his claim is a conscious lie.
Secondly, RTS in the quoted passage clearly do **not** _"brag of a lack of
direction, a lack of purpose and a lack of coherence."_ They do state there is
no _"centralised unit for decision-making"_ \-- which is true, they have a
**decentralised** unit for decision-making (direct democracy in open
meetings). There is _"no master-plan,"_ etc. as any plans are decided upon by
these open meetings. There is no pre-defined agenda because, as a democratic
organisation, it is up to the open meeting to define their own agenda.

It is only Mitchinson's **assumption** that only centralised parties, with
leaders making the decisions, can have _"direction,"_ _"purpose"_ and
_"coherence."_ As can be seen **by their actions** that RTS **does** have
direction, purpose and coherence. Needless to say, while other anarchists may
be critical about RTS and its actions, we do not deny that it has been an
effective organisation, involving a great many people in its actions who would
probably not be involved in political activities. Rather than being
_"irresponsible,"_ RTS shows the validity of libertarian organisation and its
effectiveness. No Marxist Party has remotely approached RTS's successes in
terms of involving people in political actions. This is hardly a surprise.

## 6\. How does Mitchinson define anarchism wrongly?

Mitchinson states:

> _"In reality the leaders of these movements are not devoid of ideology, they
are anarchists. Anarchism is not simply a term of abuse, it comes from the
Greek word 'anarchos' meaning 'without government'. To anarchists the state -
the institutions of government, the army, police, courts etc. - is the root
cause of all that is wrong in the world. It must be destroyed and replaced not
with any new form of government, but the immediate introduction of a stateless
society."  
>  _

Firstly, _"anarchos"_ actually means _"without authority,"_ or _"contrary to
authority"_ (as Kropotkin put it). It does **not** mean "without government"
as such (although it commonly is used that way). This means that anarchism
does **not** consider the state as _"the root of all that is wrong with the
world"_ \-- we consider it, like capitalism (wage slavery), patriarchy,
hierarchy in general, etc., as a symptom of a deeper problem, namely authority
(or, more precisely, authoritarian social relations, hierarchical power -- of
which class power is a subset). Therefore anarchist theory is concerned with
more than just the state -- it is against capitalism just as much as it is
against the state, for example.

Thus, to state the obvious, as anyone familiar with anarchist theory could
tell you, anarchists do not think that _"the state"_ is the root of all that
is wrong in the world. Marxists have asserted this for years -- unfortunately
for them, repetition does not make something true! Rather, anarchists see the
state as **one** of the causes of evil in the world and the main protector of
all the rest. We also stress that in order to combat all the evils, we need to
destroy the state so that we are in a position to abolish the other evils by
being in control of our own lives. For example, in order to abolish capitalism
-- i.e. for workers' to seize the means of life -- the state, which protects
property rights, must be destroyed. Without doing so, the police and army will
come and take back that which the workers' have taken. However, we do not
claim that the state causes all of our problems -- we do claim that getting
rid of the state is an essential act, on which many others are dependent.

As Brian Morris argues:

> _"Another criticism of anarchism is that it has a narrow view of politics:
that it sees the state as the fount of all evil, ignoring other aspects of
social and economic life. This is a misrepresentation of anarchism. It partly
derives from the way anarchism has been defined, and partly because Marxist
historians have tried to exclude anarchism from the broader socialist
movement. But when one examines the writings of classical anarchists. . . as
well as the character of anarchist movements. . . it is clearly evident that
it has never had this limited vision. It has always challenged all forms of
authority and exploitation, and has been equally critical of capitalism and
religion as it has been of the state."_ [_"Anthropology and Anarchism,"_
**Anarchy: A Journal of Desire Armed**, no. 45, p, p. 40]

As can be seen, Mitchinson repeats into the usual Marxist straw man.

## 7\. Does anarchism reject fighting for reforms?

After asserting the usual Marxist falsehoods about anarchism, he moves on:

> _"This opposition to the state and authority leads to a rejection of
participation in any form of parliamentary activity, belonging to a political
party or fighting for any reforms, that is political change through the
state."  
>  _

Again Mitchinson smuggles in a falsehood into his "analysis." Anarchists do
not reject _"fighting for any reforms"_ \-- far from it. We do reject
parliamentary activity, that is true, but we think that reforms can and must
be won. We see such reforms coming via the direct action of those who desire
them -- for example, by workers striking for better working conditions, more
wages and so. Anyone with even a passing awareness of anarchist thought would
know this. Indeed, that is what direct action means -- it was coined by French
anarcho-syndicalists to describe the struggle for reforms within capitalism!

As for rejecting parliamentary activity, yes, anarchists do reject this form
of "action." However, we do so for reasons Mitchinson fails to mention.
[Section J.2](secJ2.html) of the FAQ discusses the reasons why anarchists
support direct action and oppose electioneering as a means of both reform and
for revolution.

Similarly, anarchists reject political parties but we do not reject political
organisations -- i.e. specific anarchist groups. The difference is that
political parties are generally organised in a hierarchical fashion and
anarchist federations are not -- we try and create the new world when we
organise rather than reproducing the traits of the current, bourgeois, one.

Needless to say, Mitchinson seeks to recruit the people he is slandering and
so holds out an olive-branch by stating that _"[o]f course, Marxism is opposed
to the brutal domination of the capitalist state too. Marx saw a future
society without a state but instead 'an association in which the free
development of each is the condition for the free development of all.' That is
a self-governing people. The question however is how can this be achieved?"_

Yes, as Bakunin argued, Marxists do not reject our programme out of hand. They
claim to also seek a free society and so Mitchinson is correct -- the question
is how can this be achieved. Anarchists argue that a self-governing people can
only be achieved by self-governing means -- _"Bakunin . . . advocated
socialist (i.e., libertarian) means in order to achieve a socialist (i.e.,
libertarian) society."_ [Arthur Lehning, _"Introduction"_, **Michael Bakunin:
Selected Writings**, p. 27] Thus means and ends must be consistent --
revolutionary movements must be organised in a way that reflects the society
we want to create. Thus a self-governing society can only be created by self-
governing organisations and a self-governing movement. If the revolutionary
movement reflect bourgeois society -- for example, is hierarchical -- then it
cannot create a free society. That is the rationale for the way anarchist
groups organise, including RTS. Marxists, as we will see, disagree and
consider how a revolutionary movement organises itself as irrelevant.

Also, we must note that earlier Mitchinson denied that a self-governing
organisation could exist when he was discussing RTS. He asserted that _"[i]f
there was no leadership and no policy then there could be no action of any
kind."_ Now he claims that it is possible, but only **after** the revolution.
We will note the obvious contradiction -- how do people become capable of
self-government post-revolution if they do not practice it pre-revolution and,
obviously, during the revolution?

## 8\. Does anarchism see the state as the root of all problems?

Mitchinson moves on to assert that:

> _"Since anarchism sees in the state the root of all problems, it therefore
believes these problems will be resolved by the destruction of the state."  
>  _

As noted above, anarchists do **not** see in the state the root of all
problems. We do urge the destruction of the state but that is because the
state is the protector of existing society and in order to transform that
society we need get rid of it. Kropotkin, for example, was well aware of _"the
evil done by Capitalism and the State that supports it."_ [**Evolution and
Environment**, p. 83] Rather than seeing the State as the root of all evil,
anarchists are well aware that evil is caused by many things -- particularly
capitalism -- and that the state, as well as causing its own evils, supports
and protects others. Thus anarchists are aware that the state is a tool for
minority rule and only one source of evil.

Mitchinson, after misrepresenting anarchist thought, states:

> _"Marxism, meanwhile, sees the division of society into classes, a minority
who own the means of producing wealth, and the majority of us whose labour is
the source of that wealth, as the crux of the matter. It is this class
division of society which gives rise to the state - because the minority need
a special force to maintain their rule over the majority - which has evolved
over thousands of years into the complicated structures we see today."  
>  _

Anarchists would agree, as far as this goes. Bakunin argued that the State
_"is authority, domination, and forced, organised by the property-owning and
so-called enlightened classes against the masses."_ He saw the social
revolution as destroying capitalism and the state at the same time, that is
_"to overturn the State's domination, and that of the privileged classes whom
it solely represents."_ [**The Basic Bakunin**, p. 140] The idea that the
state is a means to ensure class rule is one anarchists, as can be seen, would
agree with.

However, anarchists do not reduce their understanding of the state to this
simplistic Marxist analysis. While being well aware that the state is the
means of ensuring the domination of an economic elite, anarchists recognise
that the state machine also has interests of its own. The state, for
anarchists, is the delegation of power into the hands of a few. This creates,
by its very nature, a privileged position for those at the top of the
hierarchy:

> _"A government, that is a group of people entrusted with making the laws and
empowered to use the collective force to oblige each individual to obey them,
is already a privileged class and cut off from the people. As any constituted
body would do, it will instinctively seek to extend its powers, to be beyond
public control, to impose its own policies and to give priority to its special
interests. Having been put in a privileged position, the government is already
at odds with the people whose strength it disposes of."_ [Malatesta,
**Anarchy**, p. 34]

Thus, while it is true that the state (particularly under capitalism) acts as
the agent of the capitalist class, it does not mean that it does not have
interests of its own. The State has developed as a means of imposing minority
rule -- that much anarchists and Marxists can agree upon. To do so it has
developed certain features, notably delegation of power into the hands of a
few. This feature of the state is a product of its function. However, function
and feature are inseparable -- retain the feature and the function will be re-
established. In other words, maintain the state and minority rule will be re-
established.

The simplistic class analysis of the state has always caused Marxists
problems, particularly Trotskyists who used it to deny the obvious class
nature of Stalinist Russia. Rather than see the USSR as a class society in
which the State bureaucracy exploited and oppressed the working class for its
own benefits, Trotskyists argued it was an autocratic, privileged bureaucracy
in a classless society. As anarchist Camillo Berneri argued:

> _"In history there is no absurdity. An autocratic bureaucracy is a class,
therefore it is not absurd that it should exist in a society where classes
remain -- the bureaucratic class and the proletarian class. If the USSR was a
'classless' society, it would also be a society without a bureaucratic
autocracy, which is the natural fruit of the permanent existence of the
State."_ [_"The State and Classes"_, **Cienfuegos Press Anarchist Review**,
no, 4, p. 49]

The weakness (or incompleteness) of the Marxist understanding of the state can
best be seen by Trotsky's and his followers lack of understanding of
Stalinism. As the state owned all the land and means of production, there
could be no classes and so the Soviet Union must be a classless society.
However, the obvious privileges of the bureaucracy could not be denied (as
Trotsky was once a leading bureaucrat, he saw and experienced them at first
hand). But as the state bureaucracy could not be a class and have class
interests (by definition), Trotsky could not see the wood for the trees. The
actual practice of Leninism in power is enough to expose its own theoretical
weaknesses.

## 9\. Why is Mitchinson wrong about the _"Abolishion [i.e. Abolition] of the
state"_?

Mitchinson moves on to argue that the _"modern capitalist state can wear many
guises, monarchy, republic, dictatorship, but in the end its purpose remains
the same, to maintain the minority rule of the capitalist class. Marxism's
goal therefore is not simply to abolish the state, but to put an end to class
society."_ Needless to say, that is also anarchism's goal. As Bakunin argued,
_"political transformation . . . [and] economic transformation . . . must be
accomplished together and simultaneously."_ [**The Basic Bakunin**, p. 106]
So, as can be seen, anarchism's goal is not simply abolishing the state, but
to put an end to class society. That anarchists have always argued the state
and capitalism must be destroyed at the same time is easily discovered from
reading their works.

Continuing this theme he argues that the state _"was born with the split of
society into classes to defend private property. So long as there are classes
there will be a state. So, how can class society be ended? Not by its denial,
but only by the victory of one of the contending classes. Triumph for
capitalism spells ruin for millions."_

Of course, we could point out here that many anthropologists disagree with the
claim that the state is a product of class society. As Michael Taylor
summarises, the _"evidence does not give this proposition a great deal of
support. Much of the evidence which has been offered in support of it shows
only that the primary states, not long after their emergence, were
economically stratified. But this is of course consistent also with the
simultaneous rise . . . of political and economic stratification, or with the
**prior** development of the state -- i.e. of **political** stratification --
and the creation of economic stratification by the ruling class."_
[**Community, Anarchy and Liberty**, p. 132]

Also, of course, as should be obvious from what we have said previously,
anarchists do not think class society can be ended by "denial." As is clear
from even a quick reading of any anarchist thinker, anarchists seek to end
class society as well as the state. However, we reject as simplistic the
Marxist notion that the state exists purely to defend classes. The state has
certain properties **because it is a state** and one of these is that it
creates a bureaucratic class around it due to its centralised, hierarchical
nature. Within capitalism, the state bureaucracy is part of the ruling class
and (generally) under the control of the capitalist class. However, to
generalise from this specific case is wrong as the state bureaucracy is a
class in itself -- and so trying to abolish classes without abolishing the
state is doomed to failure.

## 10\. Why is Mitchinson's comment that we face either _"socialism or
barbarism"_ actually undermine his case?

Mitchinson continues:

> _"As Marx once explained the choice before us is not socialism or the status
quo, but socialism or barbarism."  
>  _

We should point out that it Rosa Luxemburg who is usually associated with this
quote. She made her famous comment during the First World War. The start of
this war saw the Marxist German Social Democratic Party (and a host of others)
vote for war credits in Parliament. This party was a mass workers' party which
aimed to used every means, including elections, to gain reforms for the
working class. The net end result of this strategy was the voting for war
credits and the support of their state and ruling class in the war -- that is,
the betrayal of the fundamental principles of socialism.

This event did not happen out of the blue. It was the end result of years of
working within the bourgeois political system, of using elections (_"political
activity"_) as a means of struggle. The Social Democratic Parties had already
been plagued with reformist elements for years. These elements, again, did not
come from nowhere but were rather the response to what the party was actually
doing. They desired to reform the party to bring its rhetoric in-line with its
practice. As one of the most distinguished historians of this period put it,
the _"distinction between the contenders remained largely a subjective one, a
difference of ideas in the evaluation of reality rather than a difference in
the realm of action."_ [C. Schorske, **German Social Democracy**, p. 38] The
debacle of 1914 was a logical result of the means chosen, the evidence was
already there for all to see (except, apparently, Lenin who praised the
_"fundamentals of parliamentary tactics"_ of the German and International
Social Democracy and how they were _"at the same time implacable on questions
of principle and always directed to the accomplishment of the final aim"_ in
his obituary of August Bebel in 1913! [Marx, Engels and Lenin, **Anarchism and
Anarcho-Syndicalism**, p. 248])

Needless to say, this result had been predicted by Bakunin over 40 years
previously. And Mitchinson wants us to repeat this strategy? As Marx said,
history repeats itself -- first it is tragedy, second time it is farce.

## 11\. Why is Mitchinson wrong to assert anarchists do not believe in
defending a revolution?

Mitchinson argues that the _"victory of the working class can only mean the
destruction of the capitalist state. Will the capitalists take defeat like
sporting ladies and gentlemen, retiring quietly to the pavilion? No, all
history suggests that they would not. The workers would need to create a new
state, for the first time to defend the rule of the majority over the
minority."_

Yes, indeed, all history **does** show that a ruling class will not retire
quietly and a revolution will need to defend itself. If anarchists **did**
believe that they would retire peacefully then Marxists would be correct to
attack us. However, Marxist assertions are false. Indeed, they must think
anarchists are morons if they genuinely do think we do not believe in
defending a revolution. A few quotes should suffice to expose these Marxist
claims as lies:

> _"Commune will be organised by the standing federation of the Barricades. .
. [T]he federation of insurgent associations, communes and provinces . . .
[would] organise a revolutionary force capable of defeating reaction . . . it
is the very fact of the expansion and organisation of the revolution for the
purpose of self-defence among the insurgent areas that will bring about the
triumph of the revolution."_ [**Michael Bakunin: Selected Writings**, pp.
170-1]

>

> _"[L]et us suppose . . . it is Paris that starts [the revolution] . . .
Paris will naturally make haste to organise itself as best it can, in
revolutionary style, after the workers have joined into associations and made
a clean sweep of all the instruments of labour, every kind of capital and
building; armed and organised by streets and **quartiers**, they will form the
revolutionary federation of all the **quartiers**, the federative commune. . .
All the French and foreign revolutionary communes will then send
representatives to organise the necessary common services . . . and to
organise common defence against the enemies of the Revolution."_ [**Op.
Cit.**, p. 178-9]

Bakunin was well aware that revolution implied "civil war" -- i.e. attempts by
the ruling class to maintain its power (see, for example, his _"Letters to a
Frenchman"_ in **Bakunin on Anarchism**). As can be seen, Bakunin was well
aware of the needs to defend a revolution after destroying the state and
abolishing capitalism. Similarly we discover Malatesta arguing that we should
_"[a]rm all the population,"_ and the _"creation of a voluntary militia,
without powers to interfere as militia in the life of the community, but only
to deal with any armed attacks by the forces of reaction to re-establish
themselves, or to resist outside intervention by countries as yet not in a
state of revolution."_ [**Life and Ideas**, p. 170 and p. 166] In Malatesta's
words:

> _"But, by all means, let us admit that the governments of the still
unemancipated countries were to want to, and could, attempt to reduce free
people to a state of slavery once again. Would this people require a
government to defend itself? To wage war men are needed who have all the
necessary geographical and mechanical knowledge, and above all large masses of
the population willing to go and fight. A government can neither increase the
abilities of the former nor the will and courage of the latter. And the
experience of history teaches us that a people who really want to defend their
own country are invincible: and in Italy everyone knows that before the corps
of volunteers (anarchist formations) thrones topple, and regular armies
composed of conscripts or mercenaries disappear. . . [Some people] seem almost
to believe that after having brought down government and private property we
would allow both to be quietly built up again, because of a respect for the
**freedom** of those who might feel the need to be rulers and property owners.
A truly curious way of interpreting our ideas!"_ [**Anarchy**, pp. 40-1]

Not only do we have this theoretical position, we can also point to concrete
historical examples -- the Makhnovist movement in the Russian Revolution and
the CNT militias during the Spanish Revolution, among others -- that prove
that anarchists do recognise the need and importance of defending a successful
revolution.

Therefore, statements asserting that anarchists are against defending a
revolution are either spreading a conscious lie or a product of deep
ignorance.

Thus the question is **not** one of defending or not defending a revolution.
The question is **how** do we defend it (and, another key question, what
**kind** of revolution do we aim for). Marxists urge us to _"create a new
state, for the first time to defend the rule of the majority over the
minority."_ Anarchists reply that every state is based on the delegation of
power into the hands of a minority and so cannot be used to defend the rule of
the majority over the minority. Rather, it would be the rule of those who
claim to represent the majority. The confusion between people power and party
power is at the root of why Leninism is not revolutionary.

Mitchinson then quotes Lenin and Trotsky to defend his assertion:

> _"The proletariat needs the state only temporarily. We do not at all
disagree with the anarchists on the question of the abolition of the state as
the aim. We maintain that, to achieve this aim, we must temporarily make use
of the instruments resources and methods of state power against the
exploiters."_ [Lenin]

>

> _"Marxists are wholly in agreement with the anarchists in regard to the
final goal: the liquidation of the state. Marxists are statist only to the
extent that one cannot achieve the liquidation of the state simply by ignoring
it."_ [Trotsky]

Of course, quoting Lenin or Trotsky when they make a false assertion does not
turn lies into truth. As proven above, anarchists are well aware of the
necessity of overthrowing the state by revolution **and** defending that
revolution against attempts to defeat it. To state otherwise is to
misrepresent anarchist theory on this subject. Moreover, despite Trotsky's
claims, anarchists are aware that you do not destroy something by ignoring it.
The real question is thus **not** whether to defend a revolution or whether to
shatter the state machine. The questions are, **how** do you shatter the
state, what do you replace existing society with and how do you defend a
revolution. To state otherwise is to build a strawman -- unfortunately much of
Lenin's "masterpiece" **The State and Revolution** is based on destroying this
self-created strawman.

## 12\. Would the "workers' state" really be different, as Mitchinson claims?

Mitchinson argues that from _"the very beginning this would be like no
previous state machine. From day one it would be in effect a semi-state."_ The
question is, for anarchists, whether this "semi-state" is marked by the
delegation of power into the hands of a government. If so, then the "semi-
state" is no such thing -- it is a state like any other and so an instrument
of minority rule. Yes, this minority may state it represents the majority but
in practice it can only represent itself and claim that is what the majority
desires.

Hence, for anarchists, _"the essence of the state . . . [is] centralised power
**or to put it another way the coercive authority** of which the state enjoys
the monopoly, in that organisation of violence know as 'government'; in the
hierarchical despotism, juridical, police and military despotism that imposes
laws on everyone."_ [Luigi Fabbri, **Op. Cit.**, pp. 24-5] The so-called
"semi-state" is nothing of the kind -- it is a centralised power in which a
few govern the many. Therefore, the "workers' state" would be "workers" in
name only.

Mitchinson continues:

> _"The task of all previous revolutions was to seize state power. From the
experience of the Paris Commune of 1871 Marx and Engels concluded that it
would not be possible for the workers to simply use the old state apparatus,
they would instead have to replace it with an entirely new one, to serve the
interests of the majority and lay the basis for a socialist society."  
>  _

Needless to say, he forgets the **key** question -- **who** is to seize power.
Is it the majority, directly, or a minority (the leaders of a party) who claim
to represent the majority. Leninists are clear, it is to be the party, not the
working class as a whole. They confuse party power with class power. In the
words of Lenin:

> _"The very presentation of the question -- 'dictatorship of the Party **or**
dictatorship of the class, dictatorship (Party) of the leaders **or**
dictatorship (Party) of the masses?' -- is evidence of the most incredible and
hopeless confusion of mind . . . [because] classes are usually . . . led by
political parties. . . "_

And:

> _"To go so far in this matter as to draw a contrast in general between the
dictatorship of the masses and the dictatorship of the leaders, is
ridiculously absurd and stupid."_ [**Left-wing Communism: An Infantile
Disorder**, pp. 25-6 and p. 27]

However, what is **truly** stupid is confusing the rule by a minority with
that of the majority managing their own affairs. The two things are different,
they generate different social relationships and to confuse the two is to lay
the ground work for the rule by a bureaucratic elite, a dictatorship of state
officials **over** the working class.

Now we come to the usual Leninist claims about Bolshevik theory:

> _"To ensure that the workers maintain control over this state, Lenin argued
for the election of all officials who should be held accountable and subject
to recall, and paid no more than the wage of a skilled worker. All
bureaucratic tasks should be rotated. There should be no special armed force
standing apart from the people, and we would add, all political parties except
fascists should be allowed to organise."  
>  _

This is what Lenin, essentially, said he desired in **The State and
Revolution** (Mitchinson misses out one key aspect, to which we will return
later). Anarchists reply in three ways.

Firstly, we note that _"much that passes for 'Marxism' in **State and
Revolution** is pure anarchism -- for example, the substitution of
revolutionary militias for professional armed bodies and the substitution of
organs of self-management for parliamentary bodies. What is authentically
Marxist in Lenin's pamphlet is the demand for 'strict centralism,' the
acceptance of a 'new' bureaucracy, and the identification of soviets with a
state."_ [Murray Bookchin, **Post-Scarcity Anarchism**, p. 213] As an example,
let us look at the recall of "officials" (inspired by the Paris Commune). We
find this in Bakunin's and Proudhon's work **before** it was applied by the
Communards and praised by Marx. Bakunin in 1868 argued for a _"Revolutionary
Communal Council"_ composed of _"delegates . . . vested with plenary but
accountable and removable mandates."_ [**Michael Bakunin: Selected Writings**,
pp. 170-1] Proudhon's election manifesto of 1848 argued for _"universal
suffrage and as a consequence of universal suffrage, we want implementation of
the binding mandate. Politicians balk at it! Which means that in their eyes,
the people, in electing representatives, do not appoint mandatories but rather
abjure their sovereignty! That is assuredly not socialism: it is not even
democracy."_ [**No Gods, No Masters**, vol. 1, p. 63] As can be seen, Lenin's
recommendations were first proposed by anarchists.

Thus the positive aspects of Lenin's work are libertarian in nature, **not**
Marxist as such. Indeed given how much time is spent on the Paris Commune (an
essentially libertarian revolt obviously inspired by Proudhon's ideas) his
work is more libertarian than Marxist, as Bookchin makes clear. It is the non-
libertarian aspects which helped to undermine the anarchist elements of the
work.

Secondly, Lenin does not mention, never mind discuss, the role of the
Bolshevik Party would have in the new "semi-state." Indeed, the party is
mentioned only in passing. That in itself indicates the weakness of using
**The State and Revolution** as a guide book to Leninist theory or practice.
Given the importance of the role of the party in Lenin's previous and latter
works, it suggests that to quote **The State and Revolution** as proof of
Leninism's democratic heart leaves much to be desired. And even **The State
and Revolution**, in its one serious reference to the Party, is ambiguous in
the extreme:

> _"By educating the workers' party, Marxism educates the vanguard of the
proletariat which is capable of assuming power and **of leading the whole
people** to Socialism, of directing and organising the new order, of being the
teacher, the guide, the leader of all the toiling and exploited in the task of
building up their social life without the bourgeoisie and against the
bourgeoisie."_ [**The Essential Lenin**, p. 288]

Is it the vanguard **or** the proletariat which is _"capable of assuming
power"_? The answer is important as a **social** revolution requires the
fullest participation of the formerly oppressed masses in the management of
their own affairs. In the context of the rest of **The State and Revolution**
it could be argued it is the proletariat. However, this cannot be squared with
Lenin's (or Trotsky's) post-October arguments and practices or the resolution
of the Second World Congress of the Communist International which stated that
_"[e]very class struggle is a political struggle. The goal of this struggle .
. . is the conquest of political power. Political power cannot be seized,
organised and operated except through a political party."_ [cited by Duncan
Hallas, **The Comintern**, p. 35] It is obvious that if the party rules, the
working class does not. A socialist society cannot be built without the
participation, self-activity and self-management of the working class. Thus
the question of **who** makes decisions and **how** they do so is essential --
if it is not the masses then the slide into bureaucracy is inevitable.

Thus to quote **The State and Revolution** proves nothing for anarchists -- it
does not discuss the key question of the party and so fails to present a clear
picture of Leninist politics and their immediate aims. As soon becomes clear
if you look at Leninism in power -- i.e. what it actually did when it had the
chance, to which we now turn.

Thirdly, we point to what he actually **did** in power. In this we follow
Marx, who argued that we should judge people by what they do rather than what
they say. We will concentrate on the pre-Civil War (October 1917 to May 1918)
period to indicate that this breaking of promises started **before** the
horrors of Civil War can be claimed to have forced these decisions onto the
Bolsheviks.

Before the out-break of Civil War, the Bolsheviks had replaced election of
_"all officials"_ by appointment from above in many areas of life -- for
example, they abolished the election of officers in the Red Army and replaced
workers' self-management in production with one-man management, both forms of
democracy being substituted by appointed from above. In addition, by the end
of April, 1918, Lenin **himself** was arguing _"[o]bedience, and unquestioning
obedience at that, during work to the one-man decisions of Soviet directors,
of the dictators elected **or appointed** by Soviet institutions, vested with
dictatorial powers."_ [**Six Theses on the Immediate Tasks of the Soviet
Government**, p. 44 -- our emphasis] Moreover, the Soviet Constitution stated
that _"[e]very commissar [of the Council of People's Commissars -- i.e. the
Soviet government] has a collegium (committee) of which he is the president,
and the members of which are appointed by the Council of People's
Commissars."_ Appointment was the rule at the very heights of the state. The
_"election of all officers"_ (_"without exception"_ [Lenin, **The State and
Revolution**, p. 302]) had ended by month six of the revolution even in
Lenin's own writings -- and **before** the start of the Civil War.

Lenin also argued in mid-April 1918 that the _"socialist character of Soviet,
i.e. **proletarian**, democracy"_ lies, in part, in _"the people themselves
determin[ing] the order and time of elections."_ [**The Immediate Tasks of the
Soviet Government**, pp. 36-7] Given that _"the government [had] continually
postponed the new general elections to the Petrograd Soviet, the term of which
had ended in March 1918"_ because it _"feared that the opposition parties
would show gains"_ Lenin's comments seem hypocritical in the extreme. [Samuel
Farber, **Before Stalinism**, p. 22]

Moreover, the Bolsheviks did not stay true to Lenin's claim in **The State and
Revolution** that _"since the majority of the people **itself** suppresses its
oppressors, a 'special force' is **no longer necessary**"_ as so _"in place of
a **special** repressive force, the whole population itself came on the
scene."_ In this way the _"state machine"_ would be _"the armed masses of
workers who become transformed into a universal people's militia."_ [**Op.
Cit.**, p. 301, p. 320 and p. 347] Instead they created a political police
force (the Cheka) and a standing army (in which elections were a set aside by
decree). These were special, professional, armed forces standing apart from
the people and unaccountable to them. Indeed, they were used to repress
strikes and working class unrest. So much for Mitchinson's claim that _"there
should be no special armed force standing apart from the people"_ \-- it did
not last three months (the Cheka was founded two months into the revolution,
the Red Army was created in early 1918 and elections set aside by March of
that year).

Lastly, the Bolsheviks banned newspapers from the start -- including other
socialist papers. In addition, they did not allow other political tendencies
to organise freely. The repression started **before** the Civil War with the
attack, by the Cheka, in April 1918 on the anarchist movements in Petrograd
and Moscow. While repression obviously existed during the Civil War, it is
significant that it, in fact, started **before** it began. During the Civil
War, the Bolsheviks repressed all political parties, including the Mensheviks
even though they _"consistently pursued a policy of peaceable opposition to
the Bolshevik regime, a policy conducted by strictly legitimate means"_ and
_"[i]ndividual Mensheviks who joined organisations aiming at the overthrow of
the Soviet Government were expelled from the Menshevik Party."_ [George
Leggett, **The Cheka: Lenin's Political Police**, pp. 318-9 and p. 332] In
fact, repression **increased** after the end of the Civil War -- a strange
fact if it was that war which necessitated repression in the first place.

Moreover, Mitchinson fails to mention Lenin's argument that, like the Paris
Commune, the workers' state would be based on a fusion of executive and
administrative functions in the hands of the workers' delegates. This is
hardly surprising, as Lenin created an executive body (the Council of People's
Commissars) immediately after the October Revolution. This division of
executive and administrative powers was written into the Soviet Constitution.
So much for **The State and Revolution** \-- its promises did not last a
night.

Thus, his claims that the "semi-state" would not be like any other state are
contradicted by the actual experience of Bolshevism in power. For anarchists,
this comes as no surprise as they are well aware that the state machine does
not (indeed, **cannot**) represent the interests of the working classes due to
its centralised, hierarchical and elitist nature -- all it can do is represent
the interests of the party in power, its own bureaucratic needs and privileges
and slowly, but surely, remove itself from popular control. Hence the movement
away from popular control -- it is the nature of centralised power to remove
itself from control from below, control by the masses, particularly when all
other focal points of working class self-management have been abolished as
being no longer required as we have a "semi-state."

Mitchinson seems to want us to look purely at Bolshevik theory and not its
practice. It is exactly what supporters of capitalism desire us to do -- in
theory, capitalism is based on free agreement and free exchange between
autonomous individuals but in practice it is a system of inequality which
violates the autonomy of individuals and makes a mockery of free agreement.

In a way, **The State and Revolution** laid out the foundations and sketched
out the essential features of an alternative to Bolshevik power -- as noted,
that system would be essentially libertarian. Only the pro-Leninist tradition
has used Lenin's work, almost to quiet their conscience, because Lenin, once
in power, ignored it totally. Such is the nature of the state -- as Kropotkin
and all other anarchists have argued, there can be no such thing as a
"revolutionary government." Conflict will inevitably arise between the party
which aims to control the revolution and the actions of the masses themselves.
To resolve the conflict the state must eliminate the organs of workers self-
activity which the revolution creates otherwise the party cannot impose its
decisions -- and this is what the Bolshevik state did, aided of course by the
horrors of the civil war.

To state the obvious, to quote theory and not relate it to the practice of
those who claim to follow that theory is a joke. It is little more than
sophistry. If you look at the actions of the Bolsheviks before and after the
Russian Revolution you cannot help draw the conclusion that Lenin's **State
and Revolution** has nothing to do with Bolshevik policy and presents a false
image of what Trotskyists desire.

## 13\. Is the Marxist "worker's state" really the rule of one class over
another?

Mitchinson argues that the _"task of this state would be to develop the
economy to eradicate want. Less need, means less need to govern society, less
need for a state. Class society and the state will begin to wither away as the
government of people, the rule of one class over another, is replaced by the
administration of things, the planned use of resources to meet society's
needs."_

As Malatesta makes clear, this is pure sophistry:

> _"Whoever has power over things has power over men; whoever governs
production also governs the producers; who determines consumption is master
over the consumer. _

>

> _"This is the question; either things are administered on the basis of free
agreement of the interested parties, and this is anarchy; or they are
administered according to laws made by administrators and this is government,
it is the State, and inevitably it turns out to be tyrannical. _

>

> _"It is not a question of the good intentions or the good will of this or
that man, but of the inevitability of the situation, and of the tendencies
which man generally develops in given circumstances."_ [**Life and Ideas**, p.
145]

Moreover, it is debatable whether Trotskyists really desire the rule of one
class over another in the sense of working class over capitalist class. To
quote Trotsky:

> _"the proletariat can take power only through its vanguard. In itself the
necessity for state power arises from an insufficient cultural level of the
masses and their heterogeneity. In the revolutionary vanguard, organised in a
party, is crystallised the aspirations of the masses to obtain their freedom.
Without the confidence of the class in the vanguard, without support of the
vanguard by the class, there can be no talk of the conquest of power. _

>

> _"In this sense the proletarian revolution and dictatorship are the work of
the whole class, but only under the leadership of the vanguard."_ [**Stalinism
and Bolshevism**]

Thus, rather than the working class as a whole seizing power, it is the
"vanguard" which takes power -- _"a revolutionary party, even after seizing
power . . . is still by no means the sovereign ruler of society."_ [**Ibid.**]
That is, of course, true -- they are still organs of working class self-
management (such as factory committees, workers councils, trade unions,
soldier committees) through which working people can still exercise their
sovereignty. Little wonder Trotsky abolished independent unions, decreed the
end of soldier committees and urged one-man management and the militarisation
of labour when in power. Such working class organs do conflict with the
sovereign rule of the party and so have to be abolished.

After being in power four years, Trotsky was arguing that the _"Party is
obliged to maintain its dictatorship . . . regardless of temporary
vacillations even in the working class . . . The dictatorship does not base
itself at every moment on the formal principle of a workers' democracy."_
[quoted by Brinton, **The Bolsheviks and Workers' Control**, p. 78]

This position follows naturally from Trotsky's comments that the party
_"crystallises"_ the _"aspirations"_ of the masses. If the masses reject the
party then, obviously, their _"cultural level"_ has fallen and so the party
has the right, nay the duty, to impose its dictatorship over them. Similarly,
the destruction of organs of working class self-management can be justified
because the vanguard has taken power -- which is **exactly** what Trotsky
argued.

With regards to the Red Army and its elected officers, he stated in March 1918
that _"the principle of election is politically purposeless and technically
inexpedient, and it has been, in practice, abolished by decree"_ because the
Bolshevik Party held power or, as he put it, _"political power is in the hands
of the same working class from whose ranks the Army is recruited."_ Of course,
power was actually held by the Bolshevik party, not the working class, but
never fear:

> _"Once we have established the Soviet regime, that is a system under which
the government is headed by persons who have been directly elected by the
Soviets of Workers', Peasants' and Soldiers' Deputies, there can be no
antagonism between the government and the mass of the workers, just as there
is no antagonism between the administration of the union and the general
assembly of its members, and, therefore, there cannot be any grounds for
fearing the **appointment** of members of the commanding staff by the organs
of the Soviet Power."_ [**Work, Discipline, Order**]

He made the same comments with regard the factory committees:

> _"It would be a most crying error to confuse the question as to the
supremacy of the proletariat with the question of boards of workers at the
head of factories. The dictatorship of the proletariat is expressed in the
abolition of private property in the means of production, in the supremacy of
the collective will of the workers [a euphemism for the Party -- M.B.] and not
at all in the form in which individual economic organisations are
administered."_ [quoted by Maurice Brinton, **Op. Cit.**, p. 66]

This point is reiterated in his essay, _"Bolshevism and Stalinism"_ (written
in 1937) when he argued that:

> _"Those who propose the abstraction of Soviets to the party dictatorship
should understand that only thanks to the party dictatorship were the Soviets
able to lift themselves out of the mud of reformism and attain the state form
of the proletariat."_ [Trotsky, **Stalinism and Bolshevism**]

And, obviously, without party dictatorship the soviets would return to the
_"mud."_ In other words, the soviets are only important to attain party rule
and if the two come into conflict then Trotskyism provides the rule of the
party with an ideological justification to eliminate soviet democracy. Lenin's
and Trotsky's politics allowed them to argue that if you let the proletariat
have a say then the dictatorship of the proletariat could be in danger.

Thus, for Trotsky, the _"dictatorship of the proletariat"_ is independent of
allowing the proletariat to manage their own affairs directly. However,
without the means of manage their own affairs directly, control their own
lives, the proletariat are placed into the position of passive electors, who
vote for parties who rule for and over them, in their own name. Moreover, they
face the constant danger of the _"vanguard"_ nullifying even these decisions
as _"temporary vacillations."_ A fine liberation indeed.

Also, as libertarian socialist Maurice Brinton argues, none of the Bolshevik
leaders _"saw the proletarian nature of the Russian regime as primarily and
crucially dependent on the exercise of workers' power at the point of
production (i.e. workers' management of production). It should have been
obvious to them as Marxists that if the working class did not hold economic
power, its 'political' power would at best be insecure and would in fact
degenerate."_ [**Op. Cit.**, p. 42]

With direct working class sovereignty eroded by the Bolsheviks in the name of
indirect, i.e. party, sovereignty it is hardly surprising that the
dictatorship of the proletariat becomes the dictatorship **over** the
proletariat as Bakunin predicted. With the elimination of functional democracy
and self-management, indirect democracy would not be able to survive for long
in the face of centralised, top-down decision making by the ruling party.

So hopeless was Trotsky's understanding of socialism and the nature of a
working class social revolution that he even considered the Stalinist
dictatorship to be an expression of the _"dictatorship of the proletariat."_
He argued that the _"bureaucracy has expropriated the proletariat politically
in order to guard its social conquests with **its own** methods. The anatomy
of society is determined by its economic relations. So long as the forms of
property that have been created by the October Revolution are not overthrown,
the proletariat remains the ruling class."_ [**The Class Nature of the Soviet
State**]

Just to stress the point, according to Trotsky, under Stalinism **the
proletariat was the ruling class** and that Stalin's dictatorship eliminated
what remained (and it was not much) of working class political influence in
order _"to guard its social conquests"_! What social conquests could remain if
the proletariat was under the heel of a totalitarian dictatorship? Just one,
state ownership of property -- precisely the means by which the (state)
bureaucracy enforced its control over production and so the source of its
economic power (and privileges). To state the obvious, if the working class
does not **control** the property it is claimed to own then someone else does.
The economic relationship thus generated is a hierarchical one, in which the
working class is an oppressed class. Thus Trotsky identified the source of the
bureaucracy's economic power with "socialism" -- no wonder his analysis of
Stalinism (and vision of socialism) proved so disastrous.

Trotsky argues that the _"liberal-anarchist thought closes its eyes to the
fact that the Bolshevik revolution, with all its repressions, meant an
upheaval of social relations in the interests of the masses, whereas Stalin's
Thermidorian upheaval accompanies the reconstruction of Soviet society in the
interest of a privileged minority."_ [**Stalinism and Bolshevism**] However,
social relations are just that, **social** and so between individuals and
classes -- ownership of property cannot tell the whole story. What social
relations did Bolshevism bring about?

As far as the wage labour social relationship goes (and do not forget that is
the defining feature of capitalism), the Bolsheviks opposed workers' self-
management in favour of, first, _"control"_ over the capitalists and then one-
man management. No change in social relationships there. Property relations
did change in the sense that the state became the owner of capital rather than
individual capitalists, but the **social** relationship workers experienced
during the working day and within society was identical. The state bureaucrat
replaced the capitalist.

As for politics, the Bolshevik revolution replaced government with government.
Initially, it was an elected government and so it had the typical social
relationships of representative government. Later, it became a one party
dictatorship -- a situation that did not change under Stalin. Thus the social
relationships there, again, did not change. The Bolshevik Party became the
head of the government. That is all. This event also saw the reconstruction of
Soviet Society in the interest of a privileged minority -- it is well known
that the Communists gave themselves the best rations, best premises and so on.

Thus the Bolshevik revolution did **not** change the social relations people
faced and so Trotsky's comments are wishful thinking. The _"interests of the
masses"_ could not, and were not, defended by the Bolshevik revolution as it
did not change the relations of authority in a society -- the social
relationships people experienced remain unchanged. Perhaps that is why Lenin
argued that the proletarian nature of the Russian regime was ensured by the
nature of the ruling party? There could be no other basis for saying the
Bolshevik state was a workers' state. After all, nationalised property without
workers' self-management **does not change social relationships** it just
changes who is telling the workers what to do.

The important point to note is that Trotsky argued that the proletariat could
be a ruling class when it had **no** political influence, never mind
democracy, when subject to a one-party state and bureaucratic dictatorship and
when the social relations of the society were obviously capitalistic. No
wonder he found it impossible to recognise that dictatorship by the party did
not equal dictatorship by the proletariat.

Therefore, the claim that Trotskyists see the _"dictatorship of the
proletariat"_ as _"the rule of one class over another"_ is, as can be seen, a
joke. Rather they see it as the rule of the party over the rest of society,
**including** the working class. Even when that party had become a
bureaucratic nightmare, murdering millions and sending hundreds of thousands
to forced labour camps, Trotsky still argued that the _"working class"_ was
still the _"ruling class."_ Not only that, his political perspective allowed
him to justify the suppression of workers' democracy in the name of the
_"rule"_ of the workers. For this reason, anarchists feel that the real
utopians are the Leninists who believe that party rule equals class rule and
that centralised, hierarchical power in the hands of the few will not become a
new form of class rule. History, we think, supports our politics on this issue
(as in so many others).

Mitchinson argues that _"Anarchism's utopian calls to abolish the state
overnight demonstrates neither the understanding of what the state is, nor the
programme of action necessary to achieve the goal it sets itself."_ However,
as made clear, it is Marxism which is utopian, believing that rule by a party
equals rule by a class and that a state machine can be utilised by the
majority of the population. As Kropotkin argued, Anarchists _"maintain that
the State organisation, having been the force to which minorities resorted for
establishing and organising their power over the masses, cannot be the force
which will serve to destroy these privileges."_ [**Kropotkin's Revolutionary
Pamphlets**, p. 170]

Luigi Fabbri sums up the difference well:

> _"The mistake of authoritarian communists in this connection is the belief
that fighting and organising are impossible without submission to a
government; and thus they regard anarchists . . . as the foes of all
organisation and all co-ordinated struggle. We, on the other hand, maintain
that not only are revolutionary struggle and revolutionary organisation
possible outside and in spite of government interference but that, indeed,
that is the only effective way to struggle and organise, for it has the active
participation of all members of the collective unit, instead of their
passively entrusting themselves to the authority of the supreme leaders."_
[_"Anarchy and 'Scientific' Communism"_, in **The Poverty of Statism**, pp.
13-49, Albert Meltzer (ed.), p. 27]

Mitchinson moves on to the usual Marxist slander that as _"a modern philosophy
anarchism developed in the 19th century alongside the explosive growth of
capitalism and its state machine. It represented a rebellion by a section of
the petty bourgeoisie at the loss of their position in society, driven to the
wall by the growth of monopoly."_ We have refuted this assertion in another
appendix ([Reply to errors and distortions in David McNally's pamphlet
"Socialism from Below"](append3.html#app31)) and so will not do so here.

## 14\. Why do anarchists reject the Marxist notion of _"conquest of power"_?

Mitchinson now decides to quote some anarchists to back up his spurious
argument:

> _"Their case was argued by Mikhail Bakunin and his supporters in the First
International. At an anarchist conference in 1872 they argued 'The aspirations
of the proletariat can have no other aim than the creation of an absolutely
free economic organisation and federation based on work and equality and
wholly independent of any political government, and such an organisation can
only come into being through the spontaneous action of the proletariat
itself...no political organisation can be anything but the organisation of
rule in the interests of a class and to the detriment of the masses...the
proletariat, should it seize power, would become a ruling, and exploiting,
class...'"  
>  _

To understand this passage it is necessary to place it in historical context.
In 1872, the proletariat was a **minority** class within all nations **bar**
the UK. In almost all nations, the majority of the working class were either
artisans or peasants (hence the reference to _"the masses"_). To urge that the
proletariat seize power meant to advocate the class rule of a **minority** of
the working masses. Minority rule could be nothing else but the dictatorship
of a minority over the majority (a dictatorship in the usual sense of the
word), and dictatorships always become exploitative of the general population.

Thus Mitchinson's "analysis" is ahistoric and, fundamentally, unscientific and
a mockery of materialism.

Moreover, anarchists like Bakunin also made clear that the Marxist notion of
_"proletarian dictatorship"_ did not even mean that the proletariat **as a
whole** would exercise power. In his words:

> _"What does it mean, 'the proletariat raised to a governing class?' Will the
entire proletariat head the government? The Germans number about 40 million.
Will all 40 million be members of the government? The entire nation will rule,
but no one would be ruled. Then there will be no government, there will be no
state; but if there is a state, there will also be those who are ruled, there
will be slaves. _

>

> _"In the Marxists' theory this dilemma is resolved in a simple fashion. By
popular government they mean government of the people by a small number of
representatives elected by the people. So-called popular representatives and
rulers of the state elected by the entire nation on the basis of universal
suffrage -- the last word of the Marxists, as well as the democratic school --
is a lie behind which the despotism of a ruling minority is concealed, a lie
all the more dangerous in that it represents itself as the expression of a
sham popular will. _

>

> _"So . . . it always comes down to the same dismal result: government of the
vast majority of the people by a privileged minority. But this minority, the
Marxists say, will consist of workers. Yes, perhaps, of **former** workers,
who, as soon as they become rulers or representatives of the people will cease
to be workers and will begin to look upon the whole workers' world from the
heights of the state. They will no longer represent the people but themselves
and their own pretensions to govern the people."_ [**Statism and Anarchy**, p.
178]

Thus anarchists reject the notion of the dictatorship of the proletariat for
two reasons. Firstly, because it excluded the bulk of the working masses when
it was first used by Marx and Engels. Secondly, because in practice it would
mean the dictatorship of the party **over** the proletariat. Needless to say,
Mitchinson does not mention these points.

Mitchinson argues that _"[a]lthough this sounds radical enough it nonetheless
amounts to a recipe for inaction and disaster."_ And quotes Trotsky to explain
why:

> _"To renounce the conquest of power is voluntarily to leave the power with
those who wield it, the exploiters. The essence of every revolution consisted
and consists in putting a new class in power, thus enabling it to realise its
own programme in life. It is impossible to wage war and to reject victory. It
is impossible to lead the masses towards insurrection without preparing for
the conquest of power."_

For anarchists the question immediately is, _"power to who"_? As is clear from
the writings of Lenin and Trotsky they see the _"conquest of power"_ **not**
in terms of _"putting a new class in power"_ but, in fact, the
**representatives** of that class, the vanguard party, into power. Anarchists,
in contrast, argue that organs of working class self-management are the means
of creating and defending a **social** revolution as it is the only means that
the mass of people can actually run their own lives and any power over and
above these organs means dictatorship **over** the working class, a new form
of state and class power.

As Rudolf Rocker argues:

> _"Let no one object that the 'dictatorship of the proletariat' cannot be
compared to run of the mill dictatorship because it is the dictatorship of a
class. Dictatorship of a class cannot exist as such, for it ends up, in the
last analysis, as being the dictatorship of a given party which arrogates to
itself the right to speak for that class. Thus, the liberal bourgeoisie, in
their fight against despotism, used to speak in the name of the 'people'. . .
_

>

> _"We already know that a revolution cannot be made with rosewater. And we
know, too, that the owning classes will never yield up their privileges
spontaneously. On the day of victorious revolution the workers will have to
impose their will on the present owners of the soil, of the subsoil and of the
means of production, which cannot be done -- let us be clear on this --
without the workers taking the capital of society into their own hands, and,
above all, without their having demolished the authoritarian structure which
is, and will continue to be, the fortress keeping the masses of the people
under dominion. Such an action is, without doubt, an act of liberation; a
proclamation of social justice; the very essence of social revolution, which
has nothing in common with the utterly bourgeois principle of dictatorship. _

>

> _"The fact that a large number of socialist parties have rallied to the idea
of councils, which is the proper mark of libertarian socialist and
revolutionary syndicalists, is a confession, recognition that the tack they
have taken up until now has been the product of a falsification, a distortion,
and that with the councils the labour movement must create for itself a single
organ capable of carrying into effect the unmitigated socialism that the
conscious proletariat longs for. On the other hand, it ought not to be
forgotten that this abrupt conversion runs the risk of introducing many alien
features into the councils concept, features, that is, with no relation to the
original tasks of socialism, and which have to be eliminated because they pose
a threat to the further development of the councils. These alien elements are
able only to conceive things from the dictatorial viewpoint. It must be our
task to face up to this risk and warn our class comrades against experiments
which cannot bring the dawn of social emancipation any nearer -- which indeed,
to the contrary, positively postpone it. _

>

> _"Consequently, our advice is as follows: Everything for the councils or
soviets! No power above them! A slogan which at the same time will be that of
the social revolutionary."_ [**Anarchism and Sovietism**]

Or, as the Bakunin influenced Jura Federation of the First International put
it in 1874, _"the dictatorship that we want is one which the insurgent masses
exercise directly, without intermediary of any committee or government."_
[quoted by Peter Marshall, **Demanding the Impossible**, p. 631] In other
words, a situation in which the working masses defend their freedom, their
control over their own lives, from those who seek to replace it with minority
rule.



## 15\. What caused the degeneration of the Russian Revolution?

Mitchinson argues that:

> _"Anarchists see in the degeneration of the Soviet Union into a totalitarian
dictatorship proof that Bakunin was right. In reality, only Leon Trotsky and
Marxism have been able to explain the causes of that degeneration, finding its
roots not in men's heads or personalities, but in the real life conditions of
civil war, armies of foreign intervention, and the defeat of revolution in
Europe."_

Needless to say, anarchism explains the causes of the degeneration in a far
more rich way than Mitchinson claims. The underlying assumption of his
"critique" of anarchism is that the **politics** of the Bolsheviks had no
influence on the outcome of the revolution -- it was a product purely of
objective forces. He also subscribes to the contradictory idea that Bolshevik
politics were essential for the success of that revolution. The facts of the
matter is that people are faced with choices, choices that arise from the
objective conditions that they face. What decisions they make will be
influenced by the ideas they hold -- they will **not** occur automatically, as
if people were on auto-pilot -- and their ideas are shaped by the social
relationships they experience. Thus, someone placed into a position of power
over others will act in certain ways, have a certain world view, which would
be alien to someone subject to egalitarian social relations.

So, obviously the _"ideas in people's heads"_ matter, particularly during a
revolution. Someone in favour of centralisation, centralised power and who
equates party rule with class rule (like Lenin and Trotsky), will act in ways
(and create structures) totally different from someone who believes in
decentralisation and federalism. In other words, **political ideas do matter**
in society. Nor do anarchists leave our analysis at this obvious fact -- as
noted, we also argue that the types of organisation people create and work in
shapes the way they think and act. This is because specific kinds of
organisation have specific authority relations and so generate specific social
relationships. These obviously affect those subject to them -- a centralised,
hierarchical system will create authoritarian social relationships which shape
those within it in totally different ways than a decentralised, egalitarian
system. That Mitchinson denies this obvious fact suggests he knows nothing of
materialist philosophy.

Moreover, anarchists are aware of the problems facing the revolution. After
all, anarchists were involved in that revolution and wrote some of the best
works on that revolution (for example, Voline's **The Unknown Revolution**,
Arshinov's **The History of the Makhnovist Movement** and Maximov's **The
Guillotine at Work**). However, they point to the obvious fact that the
politics of the Bolsheviks played a key role in how the revolution developed.
While the terrible objective conditions may have shaped certain aspects of the
actions of the Bolsheviks it cannot be denied that the impulse for them were
rooted in Bolshevik theory. After all, anarchist theory could not justify the
suppression of the functional democracy associated with the factory committees
or the soldiers election of officers in the Red Army. Bolshevik theory could,
and did.

Indeed, Trotsky was still claiming in 1937 that the _"Bolshevik party achieved
in the civil war the correct combination of military art and Marxist
politics."_ [**Stalinism and Bolshevism**] In other words, the Bolshevik
policies implemented during the Civil War were the correct, Marxist, ones.
Also, although Lenin described the NEP (New Economic Policy) of 1921 as a
'defeat', at no stage did he describe the suppression of soviet democracy and
workers' control in such language. In other words, Bolshevik politics did play
a role, a key role, in the degeneration of the Russian Revolution and to deny
it is to deny reality. In the words of Maurice Brinton:

> _"[I]n relation to industrial policy there is a clear-cut and
incontrovertible link between what happened under Lenin and Trotsky and the
later practice of Stalinism. We know that many on the revolutionary left will
find this statement hard to swallow. We are convinced however that any honest
reading of the facts cannot but lead to this conclusion. The more one unearths
about this period [1917-21], the more difficult it becomes to define -- or
even see -- the 'gulf' allegedly separating what happened in Lenin's time from
what happened later. Real knowledge of the facts also makes it impossible to
accept . . . that the whole course of events was 'historically inevitable' and
'objectively determined.' Bolshevik ideology and practice were **themselves**
important and sometimes decisive factors in the equation, at every critical
stage of this critical period."_ [**Op. Cit.**, p. 84]

We should also point out that far from _"Leon Trotsky and Marxism"_ explaining
the degeneration of the Russian revolution, Trotsky could not understand that
a _"totalitarian dictatorship"_ could be an expression of a new minority class
and presented a decidedly false analysis of the Soviet Union as a
_"degenerated workers' state."_ That analysis led numerous Trotskyists to
support these dictatorships and oppose workers' revolts against them. In
addition, Trotsky's own reservations were only really voiced after he had lost
power. Moreover, he never acknowledged how his own policies (such as the
elimination of soldiers democracy, the militarisation of labour, etc.) played
a key role in the rise of the bureaucracy and Stalin.

Ultimately, every explanation of the degeneration of the Russian revolution by
Trotskyists ends up as an appeal to _"exception circumstances"_ \-- they blame
the rise of Stalinism on the Civil War, to the _"exceptional circumstances"_
created by that war. This can be faulted for two reasons.

Firstly, as Trotsky himself argued (with respect to the Spanish Anarchists)
_"did not the leaders of German social democracy invoke, in their time, the
same excuse? Naturally, civil war is not a peaceful and ordinary but an
'exceptional circumstance.' . . . we do severely blame the anarchist theory,
which seemed wholly suitable for times of peace, but had to be dropped rapidly
as soon as the 'exceptional circumstance' of the . . . revolution had begun."_
[**Stalinism and Bolshevism**] Needless to say, he did not apply his critique
to his own politics, which were also a form of the _"exceptional
circumstances"_ excuse. Given how quickly Bolshevik "principles" (as expressed
in **The State and Revolution**) were dropped, we can only assume that
Bolshevik ideas are also suitable purely for _"times of peace"_ as well.

Secondly, this "explanation" basically argues that, **if** the bourgeois did
not defend their power in 1917, then Leninism would have worked out fine. As
Mitchinson himself noted above, belief that the bourgeois will just go away
without a fight is _"an infantile flight of fancy."_ As Lenin argued,
_"revolution . . ., in its development, would give rise to exceptionally
complicated circumstances"_ and _"[r]evolution is the sharpest, most furious,
desperate class war and civil war. Not a single great revolution in history
has escaped civil war. No one who does not live in a shell could imagine that
civil war is conceivable without exceptionally complicated circumstances."_
[**Will the Bolsheviks Maintain Power?**, p. 80 and p. 81]

If the Civil War did solely produce the degeneration of the Russian Revolution
then all we can hope for is that in the next social revolution, the civil war
Lenin argued was inevitable is not as destructive as the Russian one. Hope is
not much of a basis to build a "scientific" socialism -- but then again,
neither is "fate" much of a basis to explain the degeneration of the Russian
Revolution but that is what Trotskyists do argue.

We discuss the Russian Revolution in more detail in the appendix on [" What
happened during the Russian Revolution?"](append41.html) of the FAQ and will
not do so here. However, we can point out the experience of the anarchist
Makhnovist movement in the Ukraine during the Russian Revolution. Facing
exactly the same objective conditions they encouraged soviet democracy, held
regular congresses of workers and peasants (the Bolsheviks tried to ban two of
them), defended freedom of the press and of association and so on. If
objective conditions determined Bolshevik policies, why did they not also
determine the policies of the Makhnovists? This practical example indicates
that the usual Trotskyist explanation of the degeneration of the Revolution is
false.

Perhaps it is because of this, that it showed an alternative to Bolshevik
politics existed and worked, that Trotskyists slander it? Trotsky himself
asserted that the Makhnovists were simply _"kulaks"_ on horseback and that
Makhno's _"followers . . . [expressed] a militant anti-Semitism."_ [Lenin and
Trotsky, **Kronstadt**, p. 80] We discuss the Makhnovist movement in the
appendix on ["Why does the Makhnovist movement show there is an alternative to
Bolshevism?"](append46.html) of the FAQ and there we refute claims that the
Makhnovist movement was a kulak (rich peasant) one. However, the charge of
_"militant anti-Semitism"_ is a serious one and so we will expose its
falsehood here and well as in [section 9](append46.html#app9) of the specified
appendix.

The best source to refute claims of anti-Semitism is to quote the work of the
Jewish anarchist Voline. He summarises the extensive evidence against such
claims:

> _"We could cover dozens of pages with extensive and irrefutable proofs of
the falseness of these assertions. We could mention articles and proclamations
by Makhno and the Council of Revolutionary Insurgents denouncing anti-
Semitism. We could tell of spontaneous acts by Makhno himself and other
insurgents against the slightest manifestation of the anti-Semitic spirit on
the part of a few isolated and misguided unfortunates in the army and the
population. . . One of the reasons for the execution of Grigoriev by the
Makhnovists was his anti-Semitism and the immense pogrom he organised at
Elizabethgrad. . . We could cite a whole series of similar facts, but we do
not find it necessary . . . and will content ourselves with mentioning briefly
the following essential facts: _

>

> _"1. A fairly important part in the Makhnovist movement was played by
revolutionists of Jewish origin. _

>

> _"2. Several members of the Education and Propaganda Commission were Jewish.
_

>

> _"3. Besides many Jewish combatants in various units of the army, there was
a battery composed entirely of Jewish artillery men and a Jewish infantry
unit. _

>

> _"4. Jewish colonies in the Ukraine furnished many volunteers to the
Insurrectionary Army. _

>

> _"5. In general the Jewish population . . . took an active part in all the
activities of the movement. The Jewish agricultural colonies . . .
participated in the regional assemblies of workers, peasants and partisans;
they sent their delegates to the regional Revolutionary Military Council. .
."_ [**The Unknown Revolution**, pp. 967-8]

Voline also quotes the eminent Jewish writer and historian M. Tcherikover
about the question of the Makhnovists and anti-Semitism. The Jewish historian
states _"with certainty that, on the whole, the behaviour of Makhno's army
cannot be compared with that of the other armies which were operating in
Russian during the events 1917-21 . . . It is undeniable that, of all these
armies, including the Red Army, the Makhnovists behaved best with regard the
civil population in general and the Jewish population in particular . . . The
proportion of **justified** complaints against the Makhnovist army, in
comparison with the others, is negligible. . . Do not speak of pogroms alleged
to have been organised by Makhno himself. That is a slander or an error.
Nothing of the sort occurred. As for the Makhnovist Army . . . **[n]ot once**
have I been able to prove the existence of a Makhnovist unit at the place a
pogrom against the Jews took place. Consequently, the pogroms in question
could not have been the work of the Makhnovists."_ [quoted by Voline, **Op.
Cit.**, p. 699]

Given that the Red Army agreed to two pacts with the Makhnovists, we can only
surmise, if Trotsky thought he was telling the truth, that Trotsky was a
hypocrite. However, Trotsky was either consciously lying or in error --
unfortunately the Trotskyist publishers of his words did not bother to note
that his assertion was false. We are sorry for this slight digression, but
many Trotskyists take Trotsky's words at face value and repeat his slander --
unless we indicate their false nature they may not take our argument
seriously.

Mitchinson continues by stating:

> _"The position of anarchism only serves to endorse the bourgeois slander
that Stalinism was inherent in Bolshevism."  
>  _

This appeal against slander is ironic from someone who writes an article full
of it. But, of course, it is **bourgeois** slander that he objects too --
Trotskyist slander (and falsification) is fine.

The question of whether it is a _"bourgeois slander"_ to argue (with
supporting evidence) that _"Stalinism was inherent in Bolshevism"_ is an
important one. Trotskyists often point out that anarchist and libertarian
Marxist critiques of Bolshevism sound similar to bourgeois ones and that
anarchist accounts of Bolshevik crimes against the revolution and working
class give ammunition to the defenders of the status quo. However, this seems
more like an attempt to stop critical analysis of the Russian Revolution than
a serious political position. Yes, the bourgeois do argue that Stalinism was
inherent in Bolshevism -- however they do so to discredit all forms of
socialism and radical social change. Anarchists, on the other hand, analyse
the revolution, see how the Bolsheviks acted and draw conclusions from the
facts in order to push forward revolutionary thought, tactics and ideas. Just
because the conclusions are similar does not mean that they are invalid -- to
label criticism of Bolshevism as _"bourgeois slander"_ is nothing less than
attempt to put people off investigating the Russian Revolution.

There is are course essential differences between the _"bourgeois slanders"_
against the Bolsheviks and the anarchist critique. The bourgeois slander is
based on an opposition to the revolution **as such** while the anarchist
critique affirms it. The bourgeois slanders are not the result of the
experiences of the working masses and revolutionaries subject to the Bolshevik
regime as the anarchist is. Similarly, the bourgeois slanders ignore the
nature of capitalist society while the anarchist critique points out that the
degeneration of the Bolshevik state and party were a result of it not breaking
with bourgeois ideas and organisational structures. Ultimately, it is **not**
a case of _"bourgeois slanders"_ but rather an honest evaluation of the events
of the Russian Revolution from a working class perspective.

To use an analogy, it is common place for the bourgeois press and ideologists
to attack trade unions as being bureaucratic and unresponsive to the needs of
their members. It is also common place for members of those same trade unions
to think exactly the same. Indeed, it is a common refrain of Trotskyists that
the trade unions **are** bureaucratic and need to be reformed in a more
democratic fashion (indeed, Mitchinson calls for the unions to be
_"transformed"_ in his essay). Needless to say, the bourgeois comments are
"correct" in the sense that the trade unions do have a bureaucracy -- their
reasons for stating that truth serve their interests and their solutions aid
those interests and not those of the members of the unions. Could a Trotskyist
say that it was a _"bourgeois slander"_ if the capitalist press point to the
bureaucratic nature of the unions when their own papers do the same?

While it may be in the interests of the ruling elite and its apologists to
scream about _"bourgeois slanders"_, it hinders the process of working class
self-emancipation to do so. As intended, in all likelihood.



## 16\. Did anarchists reject _"the need for organisation in the shape of
trade unions"_?

Mitchinson now decides to "expose" anarchism:

> _"In its early days, this modern anarchism found a certain support amongst
the workers. However, through the course of struggle workers learned the need
for organisation in the shape of the trade unions, and also for political
organisation which led to the building of the mass workers parties."_

To see the total nonsense of this claim we need only to turn to Marx. In his
words, Bakunin thought that the _"working class . . . must only organise
themselves by trades-unions."_ [Marx, Engels and Lenin, **Anarchism and
Anarcho-Syndicalism**, p. 48] Bakunin himself argued _"the natural
organisation of the masses . . . is organisation based on the various ways
that their various types of work define their day-to-day life; it is
organisation by trade association."_ [**The Basic Bakunin**, p. 139] Kropotkin
argued that the _"union [**syndicat**] is absolutely necessary. It is the only
form of workers' grouping which permits the direct struggle to be maintained
against capital without falling into parliamentarism."_ [quoted by Caroline
Cahm, **Kropotkin and the Rise of Revolutionary Anarchism**, p. 269]

So much for anarchism being against trade unions (as Mitchinson implies). As
for mass workers parties, well, history proved Bakunin right -- such parties
became corrupted, bureaucratic and reformist. For Mitchinson the last 130
years have not existed.

He goes on to argue that _"Bakunin and co. denounced participation in
parliament, or the fight for reforms as a betrayal of the revolution, they
'rejected all political action not having as its immediate and direct
objective the triumph of the workers over capitalism, and as a consequence,
the abolition of the state.'"_

We must first note that the Bakunin quote presented does not support
Mitchinson's assertions -- unless you think that reforms can only be won via
participation in parliament (something anarchists reject). The reason **why**
Bakunin rejected _"all political action"_ (i.e. bourgeois politics --
electioneering in other words) is not explained. We will now do so.

Bakunin did denounce participation in parliament. History proved him right.
Participation in parliament ensured the corruption of the Social Democratic
Parties, the Greens and a host of other radical and socialist organisations.
Mitchinson seems to have forgotten the fights against reformism that
continually occurred in the Social Democratic Parties at end of the nineteenth
and start of the twentieth centuries, a fight which ended with the defeat of
the revolutionary wing and the decision to support the nation state in the
first world war. The actual experience of using parliament confirmed Bakunin's
prediction that when _"the workers . . . send common workers . . . to
Legislative Assemblies . . . The worker-deputies, transplanted into a
bourgeois environment, into an atmosphere of purely bourgeois ideas, will in
fact cease to be workers and, becoming Statesmen, they will become bourgeois .
. . For men do not make their situations; on the contrary, men are made by
them."_ [**The Basic Bakunin**, p. 108]

What is not true, however, is that claim that Bakunin thought that _"the fight
for reforms [w]as a betrayal of the revolution."_ Bakunin was a firm believer
in the importance of struggles for reforms, but struggles of a specific kind
-- namely struggles to win reforms which are based on the **direct action** by
workers themselves:

> _"What policy should the International [Workers' Association] follow during
th[e] somewhat extended time period that separates us from this terrible
social revolution . . . the International will give labour unrest in all
countries an **essentially economic** character, with the aim of reducing
working hours and increasing salary, by means of the **association of the
working masses** . . . It will [also] propagandise its principles . . . [**Op.
Cit.**, p. 109] _

>

> _"And indeed, as soon as a worker believes that the economic state of
affairs can be radically transformed in the near future, he begins to fight,
in association with his comrades, for the reduction of his working hours and
for an increase in his salary. . . through practice and action . . . the
progressive expansion and development of the economic struggle will bring him
more and more to recognise his true enemies: the privileged classes, including
the clergy, the bourgeois, and the nobility; and the State, which exists only
to safeguard all the privileges of those classes."_ [**Op. Cit.**, p. 103]

This argument for reforms by direct action and workers' associations was a
basic point of agreement in those sections of the First International which
supported Bakunin's ideas. In the words of an anarchist member of the Jura
Federation writing in 1875:

> _"Instead of begging the State for a law compelling employers to make them
work only so many hours, the trade associations **directly impose** this
reform on the employers; in this way, instead of a legal text which remains a
dead letter, a real economic change is effected **by the direct initiative of
the workers** . . . if the workers devoted all their activity and energy to
the organisation of their trades into societies of resistance, trade
federations, local and regional, if, by meetings, lectures, study circles,
papers and pamphlets, they kept up a permanent socialist and revolutionary
agitation; if by linking practice to theory, they **realised directly**,
without any bourgeois and governmental intervention, all immediately possible
reforms, reforms advantageous not to a few workers but to the labouring mass
-- certainly then the cause of labour would be better served than . . . legal
agitation."_ [quoted by Caroline Cahm, **Kropotkin and the Rise of
Revolutionary Anarchism**, p. 226]

So much for Bakunin or the libertarian wing of the First International being
against reforms or the struggle for reforms. Anarchists have not changed their
minds on this issue.



## 17\. Why do anarchists reject political activity?

After spreading falsehoods against Bakunin, Mitchinson states that:

> _"Marxism fights for the conquest of political power by the working class
and the building of a socialist society, under which the state will wither
away. _

>

> _"Until then should workers refrain from political activity? Should they
reject all reforms that might improve their existence? Nothing would please
Blair or the bosses more."_

It is ironic that Mitchinson mentions Blair. He is, after all, the leader of
the Labour Party -- as mass workers party formed from the trade unions to use
political action to gain reforms within capitalism. The current state of
Labour indicates well the comment that _"in proportion as the socialists
become a power in the present bourgeois society and State, their socialism
must die out."_ [Kropotkin, **Kropotkin's Revolutionary Pamphlets**, p. 189]
It is as if the history of Social Democracy (or even the German Greens) does
not exist for Mitchinson -- he points to Blair to refute anarchist analysis
that Parliamentary politics corrupts the parties that use it! How strange, to
ignore the results of socialists actually using _"political activity"_ (and we
must stress that anarchists traditionally use the term _"political action"_ to
refer to electioneering, i.e. bourgeois politics, only). Obviously reality is
something which can be ignored when creating a political theory.

Needless to say, as noted above, anarchists do not _"reject all reforms."_ We
have quoted Bakunin, now we quote Kropotkin -- _"the Anarchists have always
advised taking an active part in those workers' organisations which carry on
the **direct** struggle of Labour against Capital and its protector, the
State."_ He continued by arguing that such struggle, _"better than any other
indirect means, permits the worker to obtain some temporary improvements in
the present conditions of work, while it opens his eyes to the evil done by
Capitalism and the State that supports it, and wakes up his thoughts
concerning the possibility of organising consumption, production, and exchange
without the intervention of the capitalist and the State."_ [**Evolution and
Environment**, pp. 82-3]

Thus we do not think that political action (electioneering) equates to reforms
nor even is the best means of winning reforms in the first place. Anarchists
argue that by direct action we can win reforms.

Mitchinson continues his diatribe:

> _"Of course not, we must advocate the struggle for every gain no matter how
minor, and use any and every field open to us. Only the dilettante can reject
better wages or a health care system. Precisely through these struggles, and
the struggles to transform the workers organisations the unions and the
parties, we learn and become more powerful and bring closer the day when it
will be possible to transform society for good."_

As noted, anarchists do not reject reforms. Only a dilettante misrepresents
the position of his enemies. And, as can be seen from the above quotes by
Bakunin and Kropotkin, anarchists agree with Mitchinson's comments. Anarchists
agree on the need to win reforms by direct action, which necessitates the
creation of new forms of working class organisation based on firm libertarian
principles and tactics -- organisations like workers' councils, factory
committees, community assemblies and so on.

However, when looking at the fields of struggle open to us, we evaluate them
based on a materialist basis -- looking at the implications of the tactics in
theory and how they **actually worked out in practice.** Mitchinson obviously
refuses to do this. Anarchists, on the other hand, base their politics on such
an evaluation. For example, Bakunin would have been aware of Proudhon's
experiences in the French National Assembly during the 1848 revolution:

> _"As soon as I set foot in the parliamentary Sinai, I ceased to be in touch
with the masses; because I was absorbed by my legislative work, I entirely
lost sight of current events . . . One must have lived in that isolator which
is called the National Assembly to realise how the men who are most completely
ignorant of the state of the country are almost always those who represent it
. . . fear of the people is the sickness of all those who belong to authority;
the people, for those in power, are the enemy."_ [Proudhon, quoted by Peter
Marshall, **Demanding the Impossible**, p. 244]

Similarly, the practical experiences of a socialist elected into Parliament
would be easy to predict -- they would be swamped by bourgeois politics,
issues and activities. Anarchism gained such socialists elected to parliament
as Johann Most and Ferdinand Nieuwenhuis who soon released the correctness of
the anarchist analysis. Thus actual experience confirmed the soundness of
anarchist politics. Mitchinson, on the other hand, has to deny history --
indeed, he fails to mention the history of Social Democracy at all in his
article.

Thus the claim that we should use _"every field open to us"_ is idealistic
nonsense, at total odds with any claim to use scientific techniques of
analysis (i.e. to being a scientific socialist) or a supporter of materialist
philosophy. It means the rejection of historical analysis and the embrace of
ahistoric wishful thinking.

Moreover, why do the workers need to _"transform"_ their own organisations in
the first place? Perhaps because they are bureaucratic organisations in which
power is centralised at the top, in a few hands? Why did this happen, if
fighting for reforms by any suitable means (including electioneering) was
their rationale? Perhaps because the wrong people are in positions of power?
But why are they the wrong people? Because they are right-wing, have reformist
ideas, etc. Why do they have reformist ideas? Here Mitchinson must fall
silent, because obviously they have reformist ideas because the organisations
and activities they are part of are reformist through and through. The tactics
(using elections) and organisational structure (centralisation of power) bred
such ideas -- as Bakunin and other anarchists predicted. Mitchinson's politics
cannot explain why this occurs, which explains why Lenin was so surprised when
German Social Democracy supported its ruling class during the First World War.



## 18\. How do anarchists struggle for reforms under capitalism?

Mitchinson continues his distortion of anarchism by arguing:

> _"Marxists fight for every reform, whilst at the same time explaining that
while capitalism continues none of these advances are safe. Only socialism can
really solve the problems of society."_

As noted above, anarchists also fight for every reform possible -- but by
direct action, by the strength of working people in their _"natural
organisations"_ and _"social power"_ (to use Bakunin's words). We also argue
that reforms are always in danger -- that is why we need to have strong,
direct action based organisations and self-reliance. If we leave it to leaders
to protect (never mind **win** reforms) we would not have them for long. Given
that Labour governments have whittled previous reforms just as much as
Conservative ones, anarchists feel our strategy is the relevant one.

Mitchinson continues:

> _"Our modern day anarchists, Reclaim the Streets and others, have no support
in Britain amongst the organised workers."_

Which is not true, as RTS and other anarchists do seek influence with the
organised workers (and the unorganised ones, and the unemployed, etc.). They
have invited rank-and-file trade union activists to their demonstrations to
speak, trade unionists are members of anarchist organisations, etc. Anarchists
are at the forefront of supporting strikers, particularly when their union
betrays their struggle and does not support them. For example, during the
Liverpool dockers strike RTS and the dockers formed a common front, organised
common demonstrations and so on. The trade unions did nothing to support the
dockers, RTS and other anarchist groups did. That in itself indicates the
weakness of Mitchinson's claims. It would also be useful to point out that
Trotskyists have little support amongst organised workers as well.

Moreover, anarchists do not seek to become part of the trade union bureaucracy
and so their influence cannot be easily gauged.

After asserting these dubious "facts" about anarchist influence, he continues:

> _"Some radicalised youth however are attracted to their 'direct action'
stance. There is a vacuum left by the absence of a mass Labour youth
organisation which, fighting for a socialist programme, could attract these
young workers and students. With no lead being given by the tops of the
unions, and Labour in government attacking young people, that vacuum can be
temporarily and partly filled by groups like Reclaim the Streets."_

Needless to say, Mitchinson does not pose the question **why** the Labour
government is attacking _"young people"_ (and numerous other sections of the
working class). Why has the Labour Party, a mass workers party which uses
elections to gain reforms, been attacking (as it has always done, we must
note) its support? If its because the leaders are "right-wing" then why have
the membership supported them? Why have the "right-wing" gained such
influence? Also, why is there no _"mass Labour youth organisation"_? And why
should _"young people"_ join an organisation which is part of the party which
is attacking them? And why are the _"tops of the unions"_ not giving a
_"lead"_? Perhaps because its not in their interests to do so? Because they
hate direct action and radical workers as much as the bosses?

Mitchinson's "analysis" is question begging in the extreme.

He continues:

> _"What action do they propose though? In their press statement (2/5/00) they
explain, 'We were not protesting. Under the shadow of an irrelevant parliament
we were planting the seeds of a society where ordinary people are in control
of their land, their resources, their food and their decision making. The
garden symbolised an urge to be self-reliant rather than dependent on
capitalism.'"_

Firstly, we should point out that having access to land **is** a key way for
workers to be independent of capitalism. Perhaps Mitchinson forgets Marx's
discussion of the colonies in chapter 33 of **Capital**? In it Marx discusses
how access to land allowed immigrants to America and Australia to reject wage
labour (i.e. capitalism) by providing them with the means to survive without
selling themselves on the labour market to survive. The state had to be used
to enforce the laws of supply and demand by restricting access to the land.
Or, perhaps, he had forgotten Marx's discussion in chapter 27 of **Capital**
of the role of enclosures in creating a dispossessed mass of people who were
forced, by necessity, to become the first generation of wage slaves? Either
way, access to the land **was** (and still is, in many countries) a means of
being independent of capitalism -- and one which the state acts to destroy.

Secondly, the garden was a **symbol** of a communist society, not an
expression of the type of society RTS and other anarchists desire. So, as a
**symbol** of a anti-capitalist vision, the garden is a good one given the
history of state violence used to separate working people from the land and
propel them into the labour market. However, it is only a **symbol** and not,
obviously, to be taken as an example of the future society RTS or other
anarchists desire. Only someone lacking in imagination could confuse a symbol
with a vision -- as the press release states it _"celebrated the possibility
of a world that encourages co-operation and sharing rather than one which
rewards greed, individualism and competition."_

Thirdly, as their press release states, _"Guerrilla Gardening is not a
protest; by its very nature it is a creative peaceful celebration of the
growing global anticapitalist movement."_ Mitchinson attacks the action for
being something it was never intended to be.

He "analyses" the RTS press release:

> _"The fact that parliament appears powerless to prevent job losses or the
destruction of the environment, only demonstrates that it serves the interests
of capitalism."_

Very true, as Kropotkin argued the _"State is there to protect exploitation,
speculation and private property; it is itself the by-product of the rapine of
the people. The proletariat must rely on his own hands; he can expect nothing
of the State. It is nothing more than an organisation devised to hinder
emancipation at all costs."_ [**Words of a Rebel**, p. 27] He argues elsewhere
that _"small groups of men [and women] were imbued with the . . . spirit of
revolt. They also rebelled -- sometimes with the hope of partial success; for
example winning a strike and of obtaining bread for their children . . .
Without the menace contained in such revolts, no serious concession has ever
been wrung by the people from governing classes."_ [**Evolution and
Environment**, p. 103]

Mitchinson seems to agree:

> _"However, under pressure from below it is possible to introduce reforms
through parliament that are in the interests of ordinary people."  
>  _

Thus reforms **are** possible, but only if we rely on ourselves, organise
pressure from below and use direct action to force parliament to act (if that
is required). Which is what anarchists have always argued. Without anti-
parliamentary action, parliament will ignore the population. That is what
anarchists have always argued -- we have to reply on our own organisations,
solidarity and direct action to change things for the better. Faced with such
a movement, parliament would introduce reforms regardless of who was a member
of it. Without such a movement, you end up with Tony Blair. Thus Mitchinson is
confused -- by his own logic, the anarchists are correct, we have to work
outside parliament and electioneering in order to be effective.

He continues:

> _"It is no use declaring parliament to be irrelevant, and turning your back
on it when the majority do not agree, and still look to government to make
their lives better. This is the mirror image of the sects attitude to the
Labour Party. Any and every avenue which can be used to improve our lives must
be used."_

How do you change the opinion of the majority? By changing your position to
match theirs? Of course not. You change their position by argument and proving
that direct action is more effective in making their lives better than looking
to government. Mitchinson would have a fit if someone argued _"it is no use
declaring capitalism to be wrong and fighting against it when the majority do
not agree and still look to it to make their lives better."_ If the majority
do not agree with you, then you try and change their opinion -- you do not
accept that opinion and hope it goes away by itself!

Mitchinson seems to be following Lenin when he argued _"[y]ou must not sink to
the level of the masses . . . You must tell them the bitter truth. You are
duty bound to call their bourgeois-democratic and parliamentary prejudices
what they are -- prejudices. But at the same time you must **soberly** follow
the **actual** state of the class-consciousness . . . of **all** the toiling
masses."_ [**Left-wing Communism: An Infantile Disorder**, p. 41] Obviously,
you cannot tell workers the bitter truth and at the same time follow their
prejudices. In practice, if you follow their prejudices you cannot help but
encourage faith in parliament, social democratic parties, leaders and so on.
Progress is achieved by discussing issues with people, not ducking the
question of political issues in favour of saying what the majority want to
hear (which is what the capitalist media and education system encourage them
to believe in the first place). As a means of encouraging revolutionary
thought it is doomed to failure.

Also, just to stress the point, any and every avenue which can be used to
improve our lives must be used but only if it actually is revolutionary and
does not place obstacles in the process of social change. Parliamentary action
has been proven time and time again to be a false way for radical change -- it
only ends up turning radicals into supporters of the status quo. It makes as
much sense as arguing that any and every avenue must be used to cure a
disease, including those which give you a new disease in its place.



## 19\. How does Mitchinson distorts the use of the term _"Self-reliance"_?

Mitchinson argues that:

> _"In any case this 'self-reliance' is no alternative. Self-reliance won't
get electricity into your house, educate your children or treat you when you
are ill."_

No anarchist and no one in RTS ever claimed it would. We use the term _"self-
reliance"_ in a totally different way -- as anyone familiar with anarchist or
RTS theory would know. We use it to describe individuals who think for
themselves, question authority, act for themselves and do not follow leaders.
No anarchist uses the term to describe some sort of peasant life-style. But
then why let facts get in the way of a nice diatribe?

He continues:

> _"We have the resources to cater for all of society's needs, the only
problem is that we do not own them."_

Actually, the **real** problem is that we do not **control** them. The
examples of Nationalised industries and the Soviet Union should make this
clear. In theory, they were both owned by their populations but, in practice,
they were effectively owned by those who managed them -- state bureaucrats and
managers. They were not used to cater for our needs, but rather the needs of
those who controlled them. For this reason anarchists argue that common
ownership without workers' self-management in the workplace and community
would be little more than state capitalism (wage labour would still exist, but
the state would replace the boss).

He continues with his distortion of the concept of _"self-reliance"_:

> _"Individualism (self-reliance) cannot be an alternative to socialism, where
all the resources of society are at all of our disposal, and equally we all
contribute what we can to society."_

Firstly, anarchists are socialists and mostly seek a (libertarian) communist
society where the resources of the world are at our disposal.

Secondly, self-reliance has little to do with _"individualism"_ \-- it has a
lot to do with **individuality,** however. The difference is important.

Thirdly, in a part of the press release strangely unquoted by Mitchinson, RTS
argue that their action _"celebrated the possibility of a world that
encourages co-operation and sharing rather than one which rewards greed,
individualism and competition."_ RTS are well aware that self-reliance does
not equal individualism and they are very clear that oppose individualism and
desire co-operation. Given that Mitchinson quotes from their press release, he
must know this and yet he asserts the opposite.

Mitchinson seems to equate self-reliance with _"individualism"_ and so,
presumably, capitalism. However, capitalists do not want self-reliant workers,
they want order takers, people who will not question their authority. As David
Noble points out, after an experiment in workers' control General Electric
replaces it with a the regime that was _"designed to 'break' the pilots of
their new found 'habits' of self-reliance, self-discipline, and self-
respect."_ [**Forces of Production**, p. 307]

Capitalists know the danger of self-reliant people. Self-reliant people
question authority, think for themselves, do not follow leaders and bring
these abilities into any groups they join. Thus self-reliance is not purely an
individual thing, it also refers to groups **and** classes. Anarchists desire
to see a self-reliant working class -- a class which makes its own decisions
and does not follow leaders. Thus, for anarchists, self-reliance refers to
**both** individuals and groups (just as self-management and self-liberation
does). Needless to say, for those in authority or those seeking authority
self-reliance is an evil thing which must be combated. Hence Mitchinson's
diatribe -- it is the cry of the would-be leader who is afraid his followers
will not respect his authority.



## 20\. Is anarchism an example of _"Philosophical idealism"_?

He turns to the May Day demonstration:

> _"Guerrilla gardening and its related varieties that have sprung up in
various places, is nothing more than an offshoot of the old utopian idea of
changing society by example."  
>  _

Actually, it was a specific demonstration to encourage people to get involved
in collective action, to have a good time and challenge authority and the
status quo. It was an attempt to change society by example only in the sense
that it would encourage others to act, to challenge the status quo and get
involved in collective action. If Mitchinson was consistent he would have to
oppose **every** demonstration that occurred before the final insurrection
that created the "workers' state" -- a demonstration is, by its very nature,
an example to others of what is possible, an example of our collective
strength and our desire for change. You may be critical of the nature of the
guerrilla gardening action (and many anarchists are), but you cannot
misrepresent its nature as Mitchinson does and be expected to be taken
seriously.

He continues:

> _"The roots of this scheme lie in idealist philosophy. Philosophical
idealism refers to the notion that people's actions are a consequence of their
thoughts, that ideas and not our conditions of life determine our outlook.
When, through a long process of accumulation, we change people's minds, then
they will live differently, capitalism will simply be redundant. The
capitalist class themselves will presumably sit idly by and watch their system
fall apart."_

Given that the "anti-capitalist" demonstrations have meet extensive state
violence, it is clear that those involved are well aware that capitalist class
will not just watch its power disappear.

Also, calling RTS's action _"idealist philosophy"_ is quite ironic for someone
who seems intent in ignoring the history of Social Democracy and dismisses
attempts to analyse the Bolsheviks in power as _"bourgeois slanders."_
However, Mitchinson in his diatribe forgets one of the basic arguments of
materialism -- namely that ideas themselves are part of the material world and
so influence society and how it develops. He rejects the notion that peoples
thoughts and ideas determine their actions. He obviously thinks that people
operate on auto-pilot, not thinking about their actions. However, in reality,
what people do is dependent on their thoughts -- they think about their
actions and what motivates them influences their activity. If thoughts did not
determine people's actions then Mitchinson would not have spent so much time
writing this article!

Thus Mitchinson is well aware of the importance of ideas in social change, at
least implicitly. Indeed, he argues for the need for a _"mass Labour youth
organisation which, fighting for a socialist programme, could attract these
young workers and students."_ To state the obvious, a socialist programme is a
means to _"change people's minds"_ and present the possibility of creating a
new society. Does he seriously think a socialist revolution is possible
without changing people's minds, getting them to desire a socialist society?

Moreover, if he had read Bakunin he would be aware that anarchists consider
the class struggle as the way to change people's ideas. As Bakunin argued:

> _"the germs of [socialist thought] . . . [are to] be found in the instinct
of every earnest worker. The goal . . . is to make the worker fully aware of
what he wants, to unjam within him a stream of thought corresponding to his
instinct . . . What impedes the swifter development of this salutary though
among the working masses? Their ignorance to be sure, that is, for the most
part the political and religious prejudices with which self-interested classes
still try to obscure their conscious and their natural instinct. How can we
dispel this ignorance and destroy these harmful prejudices? By education and
propaganda? . . . they are insufficient . . . [and] who will conduct this
propaganda? . . . [The] workers' world . . . is left with but a single path,
that of **emancipation through practical action** . . . It means workers'
solidarity in their struggle against the bosses. It means **trade-unions**,
**organisation** . . . To deliver [the worker] from that ignorance [of
reactionary ideas], the International relies on collective experience he gains
in its bosom, especially on the progress of the collective struggle of the
workers against the bosses . . . As soon as he begins to take an active part
in this wholly material struggle, . . . Socialism replaces religion in his
mind. . . through practice and collective experience . . . the progressive and
development of the economic struggle will bring him more and more to recognise
his true enemies . . . The workers thus enlisted in the struggle will
necessarily . . . recognise himself to be a revolutionary socialist, and he
will act as one."_ [**The Basic Bakunin**, pp. 102-3]

Thus anarchists are aware that experience determines thought but we are also
aware that thought is essential for action. We recognise the importance of
ideas in the class struggle but we also realise that the ideas people have
change as a result of that struggle. To state otherwise is to misrepresent
anarchist thought.



## 21\. How is Mitchinson's critique self-contradictory?

He continues his distortion:

> _"Whilst believing in a revolutionary struggle to overthrow capitalism,
anarchists argue that it must be replaced by...nothing."_

This is ironic for quite a few reasons. Firstly, above Mitchinson claimed that
anarchists did not aim to overthrow capitalism, just the state. Now he is
claiming we **do** believe in overthrowing capitalism. Secondly, he quoted
Trotsky saying that anarchists just ignore the state. Now Mitchinson states we
aim to overthrow the capitalism via revolutionary struggle. How do you
overthrow something via revolutionary struggle by ignoring it? His critique is
not even internally consistent.

Moreover, he is well aware what anarchists want to replace capitalism with,
after all he quotes an anarchist conference which stated that they aimed for
_"the creation of an absolutely free economic organisation and federation
based on work and equality"_! Bakunin was always arguing that the
International Workers Association should become _"an earnest organisation of
workers associations from all countries, capable of replacing this departing
world of States and bourgeoisie."_ [**The Basic Bakunin**, p. 110] In other
words, the _"future social organisation must be made solely from the bottom
upwards, by the free association of workers, first in their unions, then in
the communes, regions, nations and finally in a great federation,
international and universal."_ [**Michael Bakunin: Selected Writings**, p.
206] Even Engels acknowledged that the anarchists aimed to _"dispose all the
authorities, abolish the state and replace it with the organisation of the
International."_ [Marx, Engels and Lenin, **Op. Cit.**, p. 72] Anyone with
even a basic knowledge of anarchist theory would know this. And given that
Mitchinson stated that _"Marx saw a future society without a state"_ as well
and that he quotes Trotsky as arguing _"Marxists are wholly in agreement with
the anarchists in regard to the final goal: the liquidation of the state"_ we
can only assume that Marxists also aim at replacing it, eventually, when the
state _"withers away,"_ with _"nothing."_

This sentence, more than any other, shows the level which some Marxists will
sink to when discussing anarchism. It shows that the standard Marxist critique
of anarchism is little more than an inconsistent collection of lies,
distortion and misrepresentation. Mitchinson not only contradicts his
ideological gurus, he even contradicts himself! That is truly impressive.



## 22\. How did Trotsky make the trains run on time?

Mitchinson asks:

> _"Yet with no central apparatus, no organisation, how would the trains run
on time, how could organ transplants be organised, how could the world's
resources be channelled into permanently overcoming famine."_

Firstly, we must note the usual fallacy -- being opposed to a _"central
apparatus"_ does not imply _"no organisation."_ Instead of centralised
organisation, anarchists propose **federal** organisations in which co-
ordination is achieved by collective decision making from the bottom up. In
other words, rather than delegate power into the hands of _"leaders"_, an
anarchist organisation leaves power at the bottom and co-ordination results
from collective agreements that reflect the needs of those directly affected
by them. Thus a federal organisation co-ordinates activities but in a bottom-
up fashion rather than top-down, as in a centralised body.

Secondly, needless to say, anarchists are quite clear on who would make the
trains run on time -- the railway workers. Anarchists are firm supporters of
workers' self-management. Anyone with even a basic understanding of anarchist
theory would know that. Moreover, the experience of workers' self-management
of the railways by the anarchist union the CNT during the Spanish Revolution
indicates that such anarchism can, and does, ensure that the trains run on
time In contrast, the experience of Russia -- when the Bolsheviks did create a
_"central apparatus"_ \-- proved a total failure. It is quite appropriate that
Mitchinson uses the _"trains running on time"_ example, after all it is what
apologists for Italian fascism praised Mussolini for! This is because Trotsky
(when he ran the railways) did so in a way that Mussolini would have been
proud of -- he subjected the railway workers to military discipline:

> _"Due to the Civil War -- and to other factors less often mentioned, such as
the attitude of the railway workers to the 'new' regime -- the Russian
railways had virtually ceased to function. Trotsky, Commissar for Transport,
was granted wide emergency powers [in August 1920] to try out his theories of
'militarisation of labour.' He started out placing the railwaymen and the
personnel of the repair workshops under martial law. When the railwaymen's
trade union objected, he summarily ousted its leaders and, **with the full
support and endorsement of the Party leadership,** 'appointed others willing
to do his bidding. He repeated the procedure in other unions of transport
workers.'"_ [Maurice Brinton, **The Bolsheviks and Workers' Control**, p. 67]

He ruled the _"central apparatus"_ he created, called the Tsektran, _"along
strict military and bureaucratic lines."_ [**Ibid.**] The trains did start
moving again, of course. The question is -- do workers manage their own
activity or does some other group. Trotsky and Lenin in power decided for the
latter -- and built the _"centralised apparatus"_ required to ensure that
result. Needless to say, Trotsky did not justify his militarisation of work in
terms of necessary evils resulting from appalling objective conditions. Rather
he saw it as a matter of _"principle"_:

> _"The working class cannot be left wandering all over Russia. They must be
thrown here and there, appointed, commanded, just like soldiers." _

>

> _"The very principle of compulsory labour is for the Communist quite
unquestionable . . . the only solution to economic difficulties from the point
of view of both principle and of practice is to treat the population of the
whole country as the reservoir of the necessary labour power . . . and to
introduce strict order into the work of its registration, mobilisation and
utilisation." _

>

> _"The introduction of compulsory labour service is unthinkable without the
application . . . of the methods of militarisation of labour."_ [quoted by M.
Brinton, **Op. Cit.**, p. 61 and p. 66]

Why _"principle"_? Perhaps because Marx and Engels had stated in **The
Communist Manifesto** that one of the measures required during the revolution
was the _"[e]stablishment of industrial armies"_? [**Selected Writings**, p.
53]

Moreover, the experience of _"central apparatus"_ in Bolshevik Russia helped
create famine -- the vast bureaucracy spawned by the "workers' state" could
not handle the information a centralised distribution system required. Food
rotted in trains waiting for bureaucrats to _"channel"_ resources (and,
needless to say, the bureaucrats never went hungry).



## 23\. Can centralised planning meet the needs of the whole of society?

Our Marxist friend then quotes **Maybe**:

> _"The radical social movements that are increasingly coming together don't
want to seize power but to dissolve it. They are dreaming up many autonomous
alternative forms of social organisation, forms that are directly linked to
the specific needs of locality. What might be an alternative to capitalism for
people living currently in a housing estate in Croydon is completely different
to what might be suitable for the inhabitants of the slums of Delhi."  
>  _

He comments on these very sensible words:

> _"It cannot be of no concern to us what form a new society will take in
different countries or even different regions. The economic power we have
created over centuries can and must be used in a planned, rational way to
eradicate hunger, disease and illiteracy. It must be used in the interests of
the whole of society."_

Obviously, the needs of actual people, what sort of society they want, is
irrelevant to Marxism. Also ignored is the fact that different cultures will
have different visions of what a free society will be like. Thus, for
Mitchinson, everyone, everywhere, will be subject to the same form of society
-- _"in the interests of society."_ However, as Bakunin argued, the state _"is
an arbitrary creature in whose breast all the positive, living, individual or
local interests of the people clash, destroy and absorb each other into the
abstraction known as the common interest, the **public good** or the **public
welfare**, and where all real wills are dissolved into the other abstraction
that bears the name of **the will of the people.** It follows that this
alleged will of the people is never anything but the sacrifice and dissolution
of all the real wants of the population, just as this so-called public good is
nothing but the sacrifice of their interests."_ [**Michael Bakunin: Selected
Writings**, pp. 265-6]

The different needs of different areas and regions must be the starting point
of any social reconstruction, the basis on which we create specific programmes
to improve our societies, eco-systems and world. If we do not recognise the
diversity inherent in a world of billions of people, millions of eco-systems,
thousands of cultures, hundreds of regions then we cannot use the resources of
society to improve our lives. Instead we would have uniform plan imposed on
everything which, by its very nature, cannot take into accounts the real needs
of those who make up _"the whole of society."_ In other words, the resources
of the world must not be used by an abstraction claiming to act _"in the
interests of society"_ but rather by the people who actually make up society
themselves -- if we do that we ensure that their interests are meet directly
as they manage their own affairs and that their use reflects the specific
requirements of specific people and eco-systems and not some abstraction
called _"the interests of society"_ which, by its centralised nature, would
sacrifice those interests.

Of course, it seems somewhat strange that Mitchinson thinks that people in,
say, New Delhi or Croyden, will not seek to eradicate hunger, disease and
illiteracy as they see fit, co-operating with others as and when they need to
and creating the federative organisations required to do so. The need to share
experiences and resources does not conflict with the different areas
experimenting in different ways, expressing themselves in ways which suit
their particular needs and difficulties. As any ecologist could tell you,
different eco-systems need different forms of care. The same with communities
-- Mitchinson would drown local needs in the name of an artificial construct.

He continues:

> _"That can only be achieved by the democratic planning of society where the
power at our fingertips could be used with due respect for the future of the
planet, the conservation of it's resources, our own working conditions, and
living standards. Whether we like it or not, growing a few carrots on empty
plots of land will not eradicate hunger and famine."_

How can _"democratic planning"_ of the whole _"of society"_ take into account
the needs of specific localities, eco-systems, communities? It cannot. Respect
for the future of our planet means respecting the fundamental law of nature --
namely that conformity is death. Diversity is the law of life -- which means
that a future socialist society must be libertarian, organised from the bottom
up, based on local self-management and a respect for diversity. Such a federal
structures does not preclude co-ordinated activity (or the creation of
democratic **plans**) -- the reverse in fact, as federalism exists to allow
co-ordination -- but instead of being imposed by a few _"leaders"_ as in a
centralised system, it is the product of local needs and so reflective of the
needs of real people and eco-systems.

As for his comment about _"due respect of the future of the planet"_ is
obviously inspired by _"the youth"_ being concerned about ecological issues.
However, Leninism's desire for centralised states and planning excludes an
ecological perspective by definition. As Bakunin argued:

> _"What man, what group of individuals, no matter how great their genius,
would dare to think themselves able to embrace and understand the plethora of
interests, attitudes and activities so various in every country, every
province, locality and profession."_ [**Op. Cit.**, p. 240]

Diversity is the basis of any eco-system. Centralism cannot, as Bakunin makes
clear, embrace it.

Needless to say, Mitchinson's comments about carrots is pure stupidity and an
insult to the intelligence of his audience.



## 24\. Is technology neutral?

Mitchinson goes on:

> _"We have the power to do just that, but only if we combine new technology,
industry and the talents and active participation of millions."_

Needless to say, he fails to indicate how the millions **can** participate in
a _"centralised apparatus"_ beyond electing their _"leaders."_ Which indicates
the fallacy of Marxism -- it claims to desire a society based on the
participation of everyone yet favours a form of organisation -- centralisation
-- that precludes that participation.

In addition, he fails to note that technology and industry have been developed
by capitalists to enhance their own power. As we argued in [section
D.10](secD10.html), technology cannot be viewed in isolation from the class
struggle. This means that industry and technology was not developed to allow
the active participation of millions. The first act of any revolution will be
seizing of the means of life -- including industry and technology -- by those
who use it and, from that moment on, their radical transformation into
**appropriate** technology and industry, based on the needs of the workers,
the community and the planet. Mitchinson obvious shares the common Marxist
failing of believing technology and industry is neutral. In this he follows
Lenin. As S.A. Smith correctly summarises:

> _"Lenin believed that socialism could be built only on the basis of large-
scale industry as developed by capitalism, with its specific types of
productivity and social organisation of labour. Thus for him, capitalist
methods of labour-discipline or one-man management were not necessarily
incompatible with socialism. Indeed, he went so far as to consider them to be
inherently progressive, failing to recognise that such methods undermined
workers' initiative at the point of production. This was because Lenin
believed that the transition to socialism was guaranteed, ultimately, not by
the self-activity of workers, but by the 'proletarian' character of state
power. . . There is no doubt that Lenin did conceive proletarian power in
terms of the central state and lacked a conception of localising such power at
the point of production."_ [**Red Petrograd**, pp. 261-2]

The Russian workers, unsurprisingly, had a different perspective:

> _"Implicit in the movement for workers' control was a belief that capitalist
methods cannot be used for socialist ends. In their battle to democratise the
factory, in their emphasis on the importance of collective initiatives by the
direct producers in transforming the work situation, the factory committees
had become aware -- in a partial and groping way, to be sure -- that factories
are not merely sites of production, but also of reproduction -- the
reproduction of a certain structure of social relations based on the division
between those who give orders and those who take them, between those who
direct and those who execute . . . inscribed within their practice was a
distinctive vision of socialism, central to which was workplace democracy."_
[**Op. Cit.**, p. 261]

The movement for workers' control was undermined and finally replaced by one-
man management by the kind of _"central apparatus"_ Mitchinson urges us to
build (see M. Brinton's classic work **The Bolsheviks and Workers' Control**
for more details). Those who do not study history are doomed to repeat it.

He goes on:

> _"The economic power we have created can be compared to the destructive
force of lightning, untamed and anarchic under the market, yet organised into
cables and wires electricity transforms our lives. Industry is not the enemy,
nor are machines. The state is, but it is a symptom not the disease. It is
capitalism and its ownership of the economy, its stewardship of society that
we have to replace."  
>  _

However, unlike electricity, _"economic power"_ requires people to operate it.
The question is not whether _"machines"_ are the enemy (often they are, as
machines are used by capitalists to weaken the power of workers and control
them). The question is whether the future society we aim at is one based on
workers' and community self-management or whether it is based on an
authoritarian system of delegated power. It is clear that Marxists like
Mitchinson desire the latter -- indeed, as is clear from his diatribe, he
cannot comprehend an alternative to hierarchical organisation.

Given that one of the things capitalism and the state have in common is a
hierarchical, top-down structure, it is clear that any revolutionary movement
must fight both -- at the same time.



## 25\. Do anarchists ignore the _"strength of the working class"_?

Mitchinson argues that:

> _"The task of our time is to combine the strength and experience of the
working class and its mighty organisations with the power and energy of the
youth internationally, on the basis of a clear understanding of what
capitalism is, what the state is, and a programme for changing society. That
requires a combination of theory and action. In that combination lies the
strength of Marxism."_

The first question is surely **what** _"mighty organisations"_ of the working
class is he talking about. Is it the Labour Party? Or is it the trade unions?
Probably the latter -- if so, the question is how effective have these
_"mighty organisations"_ been recently? The answer must, surely, be "not
very." Why is that? In union there is strength, as anarchists have long been
aware. Why has this strength been so lacking? Simply because the unions are
centralised, bureaucratic and run from the top down. They have placed numerous
barriers in front of their members when they have taken militant action. That
is why anarchists urge workers to form rank-and-file controlled organisations
to manage their own struggles and take back the power they have delegated to
their so-called leaders. Only in this way, by building truly revolutionary
organisations like workers' councils (soviets), factory committees, community
assemblies and so on can they really create a _"mighty"_ force. In other
words, anarchists are well aware of the strength of working class people and
their power to change society -- indeed, as proven above, anarchism is based
on that awareness and organise appropriately!

The second question is surely to ask whether Mitchinson is aware that
**Reclaim the Streets** have been building links with rank and file trade
union militants for years -- long before Mitchinson decided to enlighten them
with _"the strength of Marxism."_ In other words, _"the strength of Marxism"_
seems to rest in telling radical working class people to do what they have
already doing! Such strength is truly amazing and must explain the prominent
role Leninists have had in the numerous anti-capitalist demonstrations and
organisations recently.

Needless to say, **anarchism** provides _"a clear understanding of what
capitalism is, what the state is, and a programme for changing society. That
requires a combination of theory and action."_ This has been proven above when
we corrected Mitchinson's numerous errors regarding anarchist theory.
Moreover, as far as combining theory and action goes, it is clear that
**anarchism** has been doing that of late, **not** Marxism. While anarchists
have been at the forefront of the anti-capitalist demonstrations, working with
others as equals, Marxists have been noticeable by their absence. Combining
theory and practice, non-hierarchically organised direct action closed down
the WTO and presented a clear message to the oppressed around the world --
**resistance is fertile.** What have Marxists achieved? Apparently producing
articles such as these, distorting the politics and activities of those who
actually **are** changing the world rather than just interpreting it. That
they cannot produce an honest critique of anarchism indicates the uselessness
of their politics.



## 26\. What does Mitchinson's article tell about the nature of Trotskyism?

He finishes his diatribe as follows:

> _"If you want to fight against capitalism, do so fully armed with a
socialist programme and perspective. Join with us in the struggle for the
socialist transformation of the planet."_

It is clear that to be _"fully armed with a socialist programme"_ means to
critique that which you know nothing about, spread slanders and lie about what
your opponents actually think. There **is** much to be critical of in the
recent anti-capitalist demonstrations and the various groups that have helped
organise and take part in them. Anarchists have been the first to point these
out. However, we have a lot to learn from them as well -- they are struggling
against capitalism and, as Kropotkin argues, _"Anarchism . . . originated in
everyday struggles"_ and _"the Anarchist movement was renewed each time it
received an impression from some great practical lesson: it derived its origin
from the teachings of life itself."_ [**Evolution and Environment**, p. 58 and
p. 57]

Thus we must critique these movements honestly and as equals -- Mitchinson, as
can be seen, does neither. He slanders those involved and dismisses out of
hand their experiences and the reasons that have brought them to struggle in a
specific way against the dominant society. In this he follows Lenin, who
argued in **Left-Wing Communism: An Infantile Disorder** that western
revolutionaries ignore their own experiences in their own -- and similar --
countries and instead follow the "lessons" of experiences gained in a near
pre-capitalist, absolutist state. The stupidity of such an approach is clear.

Mitchinson presents those in struggle with the ultimatum "subscribe to our
platform or be denounced." Little wonder that Leninists are non-existent in
the groups that have taken part and organised the anti-capitalist
demonstrations -- not willing to learn from those involved in the class
struggle, all they can do is act as petty sectarians. Sectarians expect
working class people to relate to their predetermined political positions,
whereas revolutionaries apply our politics to the conditions we face as
members of the working class. For Leninists revolutionary consciousness is not
generated by working class self-activity, but is embodied in the party. The
important issues facing the working class -- and how to fight -- are to be
determined not by the workers ourselves, but by the leadership of the party,
who are the "vanguard of the working class". Hence Mitchinson's dismissal (in
a particularly dishonest manner, we must stress) of those involved in struggle
and their experiences. True "revolution" obviously lies in the unchanging
ideas generated at the start of the twentieth century in a monarchy developing
towards capitalism, **not** in the experiences and desires of living people
fighting for freedom in the here and now. Yes, these ideas and movements can
be confused and unclear -- but they are living and subject to change by the
influence of revolutionaries who act in a libertarian manner (i.e. as equals,
willing to learn as well as teach).

The Italian Marxist Antonio Gramsci once wrote that _"to tell the truth is a
communist and revolutionary act."_ However, even he did not apply this when
discussing anarchism and the activities of anarchists (see Gwyn Williams'
**Proletarian Order**, pp. 193-4). Be that as it may, Gramsci's point is
correct. Telling the truth is a revolutionary act. If we judge Mitchinson's
article by this standard then we can only conclude that neither he nor the
politics he defends are revolutionary or communist.

Thus we find his ending comment truly a _"flight of fancy"_ \-- after reading
our comments above, we hope you agree with us. If you seek a **true**
socialist transformation of this planet rather than its degeneration into
centralised state capitalism, discover more about anarchism.

[‹ Marxists and Spanish Anarchism](/afaq/append32.html "Go to previous page" )
[up](/afaq/append3.html "Go to parent page" ) [Reply to errors and distortions
in the SWP's "Marxism and Anarchism" ›](/afaq/append34.html "Go to next page"
)

