/* ConjectureHistoryListLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.list;

import java.io.IOException;
import java.io.InputStream;

import org.grinvin.conjecture.history.ConjectureEntry;
import org.grinvin.conjecture.history.ConjectureEntryDelegate;
import org.grinvin.conjecture.history.StateEntry;
import org.grinvin.conjecture.history.StateEntryDelegate;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.LoaderSaverHelper;
import org.grinvin.io.SectionLoader;
import org.grinvin.list.ConjectureHistoryList;

import org.jdom.Document;
import org.jdom.Element;

/**
 *
 */
public class ConjectureHistoryListLoader {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//HistoryList 1.0//EN";
    
    //
    private ConjectureHistoryListLoader() { }
    
    //
    private static void loadEntries(ConjectureHistoryList list, Element element, SectionLoader sloader) {
        for (Object obj : element.getChildren("entry")) {
            Element entry = (Element)obj;
            if(entry.getAttributeValue("type").equals(StateEntry.TYPE)){
                list.add(new StateEntryDelegate().fromElement(entry, sloader));
            } else if(entry.getAttributeValue("type").equals(ConjectureEntry.TYPE)){
                list.add(new ConjectureEntryDelegate().fromElement(entry, sloader));
            }
        }
    }
    
    //
    public static void load(ConjectureHistoryList list, InputStream input, SectionLoader sloader) throws IOException {
        Document document = LoaderSaverHelper.loadDocument(input);
        if (!PUBLIC_ID.equals(document.getDocType().getPublicID()))
            throw new IOFormatException("Unkown document type: " + document.getDocType().getPublicID() + " expects " + PUBLIC_ID);
        loadEntries(list, document.getRootElement(), sloader);
    }
    
}
