/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIESE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgEraseSection(const char * const name);
	int cfgNewSection(const char * const name);

	Open the temporary output INI file with an empty section 'name'.
	If the section already exists in the user INI file,
	Erase() will succeed, but New() fail.

ob(ject): cfgNewSection
su(bsystem): inifile/2
sh(ort description): Create a new section and open the INI file for writing
lo(ng description): Creates a new section \para{name} within the user INI file
 and open the INI file for writing.
 If the INI file already contains a section \para{name}, this function
 fails.
re(lated to): cfgEraseSection
fi(le): cfgiese.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIESE.C 1.3 1999/12/13 02:22:22 ska Exp ska $";
#endif

static int mkSection(const char * const name, int overwrite)
{	int rv;

	DBG_ENTER("cfgiese.c<mkSection>", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", ovrwrite=%d", name, overwrite) )

	chkHeap
	if((rv = cfgOpenSection(name)) == CFG_ERR_NONE
	 && usrini.cfgi_avail)
		DBG_RETURN_BI( overwrite? cfgEraseCurSection(): CFG_ERR_EXIST)

	chkHeap
	if(rv != CFG_ERR_KEY)
		DBG_RETURN_I( rv)

	/* Create new section */
	Frewind(usrini.cfgi_fp);
	if((rv = cfgi_wrOpen()) == CFG_ERR_NONE
	 && (rv = cfgi_wrSetKey(name)) == CFG_ERR_NONE
	 && (rv = cfgi_copyall()) == CFG_ERR_NONE)		/* copy all the file */
		rv = cfgCreateSectionINI(name);

	chkHeap
	DBG_RETURN_I( rv)
}

int cfgEraseSection(const char * const name)
{	DBG_ENTER("cfgEraseSection", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )
	DBG_RETURN_BI(mkSection(name, 1))
}

int cfgNewSection(const char * const name)
{	DBG_ENTER("cfgNewSection", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )
	DBG_RETURN_BI( mkSection(name, 0))
}
