#               Microsoft QuickC Makefile for Bywater BASIC Interpreter
#
#		This makefile is for line-oriented QuickC only, not for
#		the QuickC integrated environment. To make the program:
#		type "nmake -f makefile.qcl".
#
#		To implement the bwx_iqc implementation (using specific
#		features for the IBM PC and compatibles), chainge each
#		instance of "bwx_iqc" to "bwx_iqc".
#
PROJ=           bwbasic
CC=             wcl

#
#		These are the normal flags I used to compile bwBASIC:
#
CFLAGS=         -oasl -c -wx -DMSDOS -k8k -bt=dos -zq -fo=.obj -ml
#
#		The following flags can be used for debugging:
#
#CFLAGS=         -Od -AL -W3 -Za -Zr -Zi -DMSDOS

LFLAGS=         /NOE /ST:8192

OFILES=         bwbasic.obj bwb_int.obj bwb_tbl.obj bwb_cmd.obj bwb_prn.obj&
                bwb_exp.obj bwb_var.obj bwb_inp.obj bwb_fnc.obj bwb_cnd.obj&
                bwb_ops.obj bwb_dio.obj bwb_str.obj bwb_elx.obj bwb_mth.obj&
		bwb_stc.obj bwb_par.obj bwx_iqc.obj

HFILES=         bwbasic.h bwb_mes.h

all:            $(PROJ).exe

$(OFILES):      $(HFILES) makefile.qcl

.c.obj:
	$(CC) $(CFLAGS) $*.c

$(PROJ).exe:    $(OFILES)
        $(CC) -k8k -zq -ml -fe=$(PROJ).exe $(OFILES)

clean: .SYMBOLIC
	-@rm *.obj *.err *.o
