/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "az_Cyrl" locale.
 */
public class LocalizedNamesImpl_az_Cyrl extends LocalizedNamesImpl_az {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "VI",
        "AC",
        "AX",
        "AL",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AW",
        "EU",
        "AU",
        "AT",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "GB",
        "UM",
        "AE",
        "BO",
        "BG",
        "BA",
        "BW",
        "BV",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "TD",
        "CZ",
        "DZ",
        "DJ",
        "CL",
        "JE",
        "CP",
        "CX",
        "ZA",
        "GS",
        "KR",
        "DK",
        "DG",
        "DM",
        "DO",
        "EA",
        "ET",
        "EC",
        "GQ",
        "SV",
        "ER",
        "AM",
        "EE",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "TF",
        "PF",
        "GF",
        "PS",
        "GI",
        "GG",
        "GE",
        "HT",
        "NL",
        "AN",
        "HK",
        "HM",
        "IC",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "SE",
        "CH",
        "CI",
        "IL",
        "KH",
        "CM",
        "CA",
        "CV",
        "KY",
        "KZ",
        "KE",
        "CY",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CU",
        "CK",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "HU",
        "MG",
        "MO",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MH",
        "MQ",
        "MK",
        "MR",
        "MU",
        "YT",
        "MZ",
        "MX",
        "FM",
        "EG",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MA",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "OM",
        "CF",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "GA",
        "GM",
        "GH",
        "QA",
        "HN",
        "GD",
        "GL",
        "GU",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "EH",
        "RE",
        "RO",
        "RW",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "KP",
        "MP",
        "SG",
        "SY",
        "SL",
        "SK",
        "SI",
        "SB",
        "SO",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "TL",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TK",
        "TO",
        "TG",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UA",
        "UG",
        "JO",
        "UY",
        "QO",
        "WF",
        "VU",
        "VA",
        "VE",
        "VN",
        "HR",
        "JM",
        "YE",
        "NC",
        "NZ",
        "GR",
        "ZM",
        "ZW",
        "AF",
        "JP",
        "AZ",
        "DE",
        "US",
        "BR",
        "IT",
        "RU",
        "FR",
        "CN",
        "IN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AZ", "Азәрбајҹан");
    namesMap.put("BR", "Бразилија");
    namesMap.put("CN", "Чин");
    namesMap.put("DE", "Алманија");
    namesMap.put("FR", "Франса");
    namesMap.put("IN", "Һиндистан");
    namesMap.put("IT", "Италија");
    namesMap.put("JP", "Јапонија");
    namesMap.put("RU", "Русија");
    namesMap.put("US", "Америка Бирләшмиш Штатлары");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AZ": "Азәрбајҹан",
        "BR": "Бразилија",
        "CN": "Чин",
        "DE": "Алманија",
        "FR": "Франса",
        "IN": "Һиндистан",
        "IT": "Италија",
        "JP": "Јапонија",
        "RU": "Русија",
        "US": "Америка Бирләшмиш Штатлары"
    };
  }-*/;
}
